package org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates;
import java.util.Collections;
import java.util.Map;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.Subs;
import java.util.List;
import org.opendaylight.yangtools.yang.binding.Augmentation;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.Apps} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.Apps
 *
 */
public class AppsBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.Apps> {

    private java.lang.String _appId;
    private AppsKey _key;
    private List<Subs> _subs;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.Apps>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.Apps>> augmentation = Collections.emptyMap();

    public AppsBuilder() {
    }

    public AppsBuilder(Apps base) {
        if (base.getKey() == null) {
            this._key = new AppsKey(
                base.getAppId()
            );
            this._appId = base.getAppId();
        } else {
            this._key = base.getKey();
            this._appId = _key.getAppId();
        }
        this._subs = base.getSubs();
        if (base instanceof AppsImpl) {
            AppsImpl impl = (AppsImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.Apps> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.Apps>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public java.lang.String getAppId() {
        return _appId;
    }
    
    public AppsKey getKey() {
        return _key;
    }
    
    public List<Subs> getSubs() {
        return _subs;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.Apps>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

    public AppsBuilder setAppId(java.lang.String value) {
        this._appId = value;
        return this;
    }
    
    public AppsBuilder setKey(AppsKey value) {
        this._key = value;
        return this;
    }
    
    public AppsBuilder setSubs(List<Subs> value) {
        this._subs = value;
        return this;
    }
    
    public AppsBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.Apps>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.Apps> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public AppsBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.Apps>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Apps build() {
        return new AppsImpl(this);
    }

    private static final class AppsImpl implements Apps {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.Apps> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.Apps.class;
        }

        private final java.lang.String _appId;
        private final AppsKey _key;
        private final List<Subs> _subs;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.Apps>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.Apps>> augmentation = Collections.emptyMap();

        private AppsImpl(AppsBuilder base) {
            if (base.getKey() == null) {
                this._key = new AppsKey(
                    base.getAppId()
                );
                this._appId = base.getAppId();
            } else {
                this._key = base.getKey();
                this._appId = _key.getAppId();
            }
            this._subs = base.getSubs();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.Apps>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.Apps>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.Apps>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.Apps>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public java.lang.String getAppId() {
            return _appId;
        }
        
        @Override
        public AppsKey getKey() {
            return _key;
        }
        
        @Override
        public List<Subs> getSubs() {
            return _subs;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.Apps>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_appId == null) ? 0 : _appId.hashCode());
            result = prime * result + ((_key == null) ? 0 : _key.hashCode());
            result = prime * result + ((_subs == null) ? 0 : _subs.hashCode());
            result = prime * result + ((augmentation == null) ? 0 : augmentation.hashCode());
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.Apps.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.Apps other = (org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.Apps)obj;
            if (_appId == null) {
                if (other.getAppId() != null) {
                    return false;
                }
            } else if(!_appId.equals(other.getAppId())) {
                return false;
            }
            if (_key == null) {
                if (other.getKey() != null) {
                    return false;
                }
            } else if(!_key.equals(other.getKey())) {
                return false;
            }
            if (_subs == null) {
                if (other.getSubs() != null) {
                    return false;
                }
            } else if(!_subs.equals(other.getSubs())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                AppsImpl otherImpl = (AppsImpl) obj;
                if (augmentation == null) {
                    if (otherImpl.augmentation != null) {
                        return false;
                    }
                } else if(!augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.Apps>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.Apps>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("Apps [");
            boolean first = true;
        
            if (_appId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_appId=");
                builder.append(_appId);
             }
            if (_key != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_key=");
                builder.append(_key);
             }
            if (_subs != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_subs=");
                builder.append(_subs);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
