package org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gate.spec;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TosByte;
import com.google.common.collect.Range;
import java.util.Collections;
import java.util.Map;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.List;
import java.math.BigInteger;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ServiceFlowDirection;
import org.opendaylight.yangtools.yang.binding.Augmentation;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gate.spec.GateSpec} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gate.spec.GateSpec
 *
 */
public class GateSpecBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gate.spec.GateSpec> {

    private ServiceFlowDirection _direction;
    private TosByte _dscpTosMask;
    private TosByte _dscpTosOverwrite;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gate.spec.GateSpec>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gate.spec.GateSpec>> augmentation = Collections.emptyMap();

    public GateSpecBuilder() {
    }

    public GateSpecBuilder(GateSpec base) {
        this._direction = base.getDirection();
        this._dscpTosMask = base.getDscpTosMask();
        this._dscpTosOverwrite = base.getDscpTosOverwrite();
        if (base instanceof GateSpecImpl) {
            GateSpecImpl impl = (GateSpecImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gate.spec.GateSpec> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gate.spec.GateSpec>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public ServiceFlowDirection getDirection() {
        return _direction;
    }
    
    public TosByte getDscpTosMask() {
        return _dscpTosMask;
    }
    
    public TosByte getDscpTosOverwrite() {
        return _dscpTosOverwrite;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gate.spec.GateSpec>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

    public GateSpecBuilder setDirection(ServiceFlowDirection value) {
        this._direction = value;
        return this;
    }
    
    private static void checkDscpTosMaskRange(final short value) {
        if (value >= (short)0 && value <= (short)255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥255]].", value));
    }
    
    public GateSpecBuilder setDscpTosMask(TosByte value) {
        if (value != null) {
            checkDscpTosMaskRange(value.getValue());
        }
        this._dscpTosMask = value;
        return this;
    }
    /**
     * @deprecated This method is slated for removal in a future release. See BUG-1485 for details.
     */
    @Deprecated
    public static List<Range<BigInteger>> _dscpTosMask_range() {
        final List<Range<BigInteger>> ret = new java.util.ArrayList<>(1);
        ret.add(Range.closed(BigInteger.ZERO, BigInteger.valueOf(255L)));
        return ret;
    }
    
    private static void checkDscpTosOverwriteRange(final short value) {
        if (value >= (short)0 && value <= (short)255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥255]].", value));
    }
    
    public GateSpecBuilder setDscpTosOverwrite(TosByte value) {
        if (value != null) {
            checkDscpTosOverwriteRange(value.getValue());
        }
        this._dscpTosOverwrite = value;
        return this;
    }
    /**
     * @deprecated This method is slated for removal in a future release. See BUG-1485 for details.
     */
    @Deprecated
    public static List<Range<BigInteger>> _dscpTosOverwrite_range() {
        final List<Range<BigInteger>> ret = new java.util.ArrayList<>(1);
        ret.add(Range.closed(BigInteger.ZERO, BigInteger.valueOf(255L)));
        return ret;
    }
    
    public GateSpecBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gate.spec.GateSpec>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gate.spec.GateSpec> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public GateSpecBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gate.spec.GateSpec>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public GateSpec build() {
        return new GateSpecImpl(this);
    }

    private static final class GateSpecImpl implements GateSpec {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gate.spec.GateSpec> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gate.spec.GateSpec.class;
        }

        private final ServiceFlowDirection _direction;
        private final TosByte _dscpTosMask;
        private final TosByte _dscpTosOverwrite;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gate.spec.GateSpec>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gate.spec.GateSpec>> augmentation = Collections.emptyMap();

        private GateSpecImpl(GateSpecBuilder base) {
            this._direction = base.getDirection();
            this._dscpTosMask = base.getDscpTosMask();
            this._dscpTosOverwrite = base.getDscpTosOverwrite();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gate.spec.GateSpec>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gate.spec.GateSpec>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gate.spec.GateSpec>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gate.spec.GateSpec>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public ServiceFlowDirection getDirection() {
            return _direction;
        }
        
        @Override
        public TosByte getDscpTosMask() {
            return _dscpTosMask;
        }
        
        @Override
        public TosByte getDscpTosOverwrite() {
            return _dscpTosOverwrite;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gate.spec.GateSpec>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_direction == null) ? 0 : _direction.hashCode());
            result = prime * result + ((_dscpTosMask == null) ? 0 : _dscpTosMask.hashCode());
            result = prime * result + ((_dscpTosOverwrite == null) ? 0 : _dscpTosOverwrite.hashCode());
            result = prime * result + ((augmentation == null) ? 0 : augmentation.hashCode());
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gate.spec.GateSpec.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gate.spec.GateSpec other = (org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gate.spec.GateSpec)obj;
            if (_direction == null) {
                if (other.getDirection() != null) {
                    return false;
                }
            } else if(!_direction.equals(other.getDirection())) {
                return false;
            }
            if (_dscpTosMask == null) {
                if (other.getDscpTosMask() != null) {
                    return false;
                }
            } else if(!_dscpTosMask.equals(other.getDscpTosMask())) {
                return false;
            }
            if (_dscpTosOverwrite == null) {
                if (other.getDscpTosOverwrite() != null) {
                    return false;
                }
            } else if(!_dscpTosOverwrite.equals(other.getDscpTosOverwrite())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                GateSpecImpl otherImpl = (GateSpecImpl) obj;
                if (augmentation == null) {
                    if (otherImpl.augmentation != null) {
                        return false;
                    }
                } else if(!augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gate.spec.GateSpec>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gate.spec.GateSpec>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("GateSpec [");
            boolean first = true;
        
            if (_direction != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_direction=");
                builder.append(_direction);
             }
            if (_dscpTosMask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dscpTosMask=");
                builder.append(_dscpTosMask);
             }
            if (_dscpTosOverwrite != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dscpTosOverwrite=");
                builder.append(_dscpTosOverwrite);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
