package org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier;
import com.google.common.collect.Range;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TpProtocol;
import java.util.Collections;
import java.util.Map;
import java.util.HashMap;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import java.math.BigInteger;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TosByte;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Address;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.PortNumber;
import org.opendaylight.yangtools.yang.binding.Augmentation;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier.ExtClassifier} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier.ExtClassifier
 *
 */
public class ExtClassifierBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier.ExtClassifier> {

    private Ipv4Address _dstIp;
    private Ipv4Address _dstIpMask;
    private PortNumber _dstPortEnd;
    private PortNumber _dstPortStart;
    private TpProtocol _protocol;
    private Ipv4Address _srcIp;
    private Ipv4Address _srcIpMask;
    private PortNumber _srcPortEnd;
    private PortNumber _srcPortStart;
    private TosByte _tosByte;
    private TosByte _tosMask;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier.ExtClassifier>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier.ExtClassifier>> augmentation = Collections.emptyMap();

    public ExtClassifierBuilder() {
    }
    public ExtClassifierBuilder(org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TpPortMatchRanges arg) {
        this._srcPortStart = arg.getSrcPortStart();
        this._srcPortEnd = arg.getSrcPortEnd();
        this._dstPortStart = arg.getDstPortStart();
        this._dstPortEnd = arg.getDstPortEnd();
    }

    public ExtClassifierBuilder(ExtClassifier base) {
        this._dstIp = base.getDstIp();
        this._dstIpMask = base.getDstIpMask();
        this._dstPortEnd = base.getDstPortEnd();
        this._dstPortStart = base.getDstPortStart();
        this._protocol = base.getProtocol();
        this._srcIp = base.getSrcIp();
        this._srcIpMask = base.getSrcIpMask();
        this._srcPortEnd = base.getSrcPortEnd();
        this._srcPortStart = base.getSrcPortStart();
        this._tosByte = base.getTosByte();
        this._tosMask = base.getTosMask();
        if (base instanceof ExtClassifierImpl) {
            ExtClassifierImpl impl = (ExtClassifierImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier.ExtClassifier> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier.ExtClassifier>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TpPortMatchRanges</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TpPortMatchRanges) {
            this._srcPortStart = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TpPortMatchRanges)arg).getSrcPortStart();
            this._srcPortEnd = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TpPortMatchRanges)arg).getSrcPortEnd();
            this._dstPortStart = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TpPortMatchRanges)arg).getDstPortStart();
            this._dstPortEnd = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TpPortMatchRanges)arg).getDstPortEnd();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TpPortMatchRanges] \n" +
              "but was: " + arg
            );
        }
    }

    public Ipv4Address getDstIp() {
        return _dstIp;
    }
    
    public Ipv4Address getDstIpMask() {
        return _dstIpMask;
    }
    
    public PortNumber getDstPortEnd() {
        return _dstPortEnd;
    }
    
    public PortNumber getDstPortStart() {
        return _dstPortStart;
    }
    
    public TpProtocol getProtocol() {
        return _protocol;
    }
    
    public Ipv4Address getSrcIp() {
        return _srcIp;
    }
    
    public Ipv4Address getSrcIpMask() {
        return _srcIpMask;
    }
    
    public PortNumber getSrcPortEnd() {
        return _srcPortEnd;
    }
    
    public PortNumber getSrcPortStart() {
        return _srcPortStart;
    }
    
    public TosByte getTosByte() {
        return _tosByte;
    }
    
    public TosByte getTosMask() {
        return _tosMask;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier.ExtClassifier>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

    public ExtClassifierBuilder setDstIp(Ipv4Address value) {
        if (value != null) {
        }
        this._dstIp = value;
        return this;
    }
    
    public ExtClassifierBuilder setDstIpMask(Ipv4Address value) {
        if (value != null) {
        }
        this._dstIpMask = value;
        return this;
    }
    
    private static void checkDstPortEndRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥65535]].", value));
    }
    
    public ExtClassifierBuilder setDstPortEnd(PortNumber value) {
        if (value != null) {
            checkDstPortEndRange(value.getValue());
        }
        this._dstPortEnd = value;
        return this;
    }
    /**
     * @deprecated This method is slated for removal in a future release. See BUG-1485 for details.
     */
    @Deprecated
    public static List<Range<BigInteger>> _dstPortEnd_range() {
        final List<Range<BigInteger>> ret = new java.util.ArrayList<>(1);
        ret.add(Range.closed(BigInteger.ZERO, BigInteger.valueOf(65535L)));
        return ret;
    }
    
    private static void checkDstPortStartRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥65535]].", value));
    }
    
    public ExtClassifierBuilder setDstPortStart(PortNumber value) {
        if (value != null) {
            checkDstPortStartRange(value.getValue());
        }
        this._dstPortStart = value;
        return this;
    }
    /**
     * @deprecated This method is slated for removal in a future release. See BUG-1485 for details.
     */
    @Deprecated
    public static List<Range<BigInteger>> _dstPortStart_range() {
        final List<Range<BigInteger>> ret = new java.util.ArrayList<>(1);
        ret.add(Range.closed(BigInteger.ZERO, BigInteger.valueOf(65535L)));
        return ret;
    }
    
    private static void checkProtocolRange(final int value) {
        if (value >= 0 && value <= 257) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥257]].", value));
    }
    
    public ExtClassifierBuilder setProtocol(TpProtocol value) {
        if (value != null) {
            checkProtocolRange(value.getValue());
        }
        this._protocol = value;
        return this;
    }
    /**
     * @deprecated This method is slated for removal in a future release. See BUG-1485 for details.
     */
    @Deprecated
    public static List<Range<BigInteger>> _protocol_range() {
        final List<Range<BigInteger>> ret = new java.util.ArrayList<>(1);
        ret.add(Range.closed(BigInteger.ZERO, BigInteger.valueOf(257L)));
        return ret;
    }
    
    public ExtClassifierBuilder setSrcIp(Ipv4Address value) {
        if (value != null) {
        }
        this._srcIp = value;
        return this;
    }
    
    public ExtClassifierBuilder setSrcIpMask(Ipv4Address value) {
        if (value != null) {
        }
        this._srcIpMask = value;
        return this;
    }
    
    private static void checkSrcPortEndRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥65535]].", value));
    }
    
    public ExtClassifierBuilder setSrcPortEnd(PortNumber value) {
        if (value != null) {
            checkSrcPortEndRange(value.getValue());
        }
        this._srcPortEnd = value;
        return this;
    }
    /**
     * @deprecated This method is slated for removal in a future release. See BUG-1485 for details.
     */
    @Deprecated
    public static List<Range<BigInteger>> _srcPortEnd_range() {
        final List<Range<BigInteger>> ret = new java.util.ArrayList<>(1);
        ret.add(Range.closed(BigInteger.ZERO, BigInteger.valueOf(65535L)));
        return ret;
    }
    
    private static void checkSrcPortStartRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥65535]].", value));
    }
    
    public ExtClassifierBuilder setSrcPortStart(PortNumber value) {
        if (value != null) {
            checkSrcPortStartRange(value.getValue());
        }
        this._srcPortStart = value;
        return this;
    }
    /**
     * @deprecated This method is slated for removal in a future release. See BUG-1485 for details.
     */
    @Deprecated
    public static List<Range<BigInteger>> _srcPortStart_range() {
        final List<Range<BigInteger>> ret = new java.util.ArrayList<>(1);
        ret.add(Range.closed(BigInteger.ZERO, BigInteger.valueOf(65535L)));
        return ret;
    }
    
    private static void checkTosByteRange(final short value) {
        if (value >= (short)0 && value <= (short)255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥255]].", value));
    }
    
    public ExtClassifierBuilder setTosByte(TosByte value) {
        if (value != null) {
            checkTosByteRange(value.getValue());
        }
        this._tosByte = value;
        return this;
    }
    /**
     * @deprecated This method is slated for removal in a future release. See BUG-1485 for details.
     */
    @Deprecated
    public static List<Range<BigInteger>> _tosByte_range() {
        final List<Range<BigInteger>> ret = new java.util.ArrayList<>(1);
        ret.add(Range.closed(BigInteger.ZERO, BigInteger.valueOf(255L)));
        return ret;
    }
    
    private static void checkTosMaskRange(final short value) {
        if (value >= (short)0 && value <= (short)255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥255]].", value));
    }
    
    public ExtClassifierBuilder setTosMask(TosByte value) {
        if (value != null) {
            checkTosMaskRange(value.getValue());
        }
        this._tosMask = value;
        return this;
    }
    /**
     * @deprecated This method is slated for removal in a future release. See BUG-1485 for details.
     */
    @Deprecated
    public static List<Range<BigInteger>> _tosMask_range() {
        final List<Range<BigInteger>> ret = new java.util.ArrayList<>(1);
        ret.add(Range.closed(BigInteger.ZERO, BigInteger.valueOf(255L)));
        return ret;
    }
    
    public ExtClassifierBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier.ExtClassifier>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier.ExtClassifier> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public ExtClassifierBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier.ExtClassifier>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ExtClassifier build() {
        return new ExtClassifierImpl(this);
    }

    private static final class ExtClassifierImpl implements ExtClassifier {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier.ExtClassifier> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier.ExtClassifier.class;
        }

        private final Ipv4Address _dstIp;
        private final Ipv4Address _dstIpMask;
        private final PortNumber _dstPortEnd;
        private final PortNumber _dstPortStart;
        private final TpProtocol _protocol;
        private final Ipv4Address _srcIp;
        private final Ipv4Address _srcIpMask;
        private final PortNumber _srcPortEnd;
        private final PortNumber _srcPortStart;
        private final TosByte _tosByte;
        private final TosByte _tosMask;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier.ExtClassifier>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier.ExtClassifier>> augmentation = Collections.emptyMap();

        private ExtClassifierImpl(ExtClassifierBuilder base) {
            this._dstIp = base.getDstIp();
            this._dstIpMask = base.getDstIpMask();
            this._dstPortEnd = base.getDstPortEnd();
            this._dstPortStart = base.getDstPortStart();
            this._protocol = base.getProtocol();
            this._srcIp = base.getSrcIp();
            this._srcIpMask = base.getSrcIpMask();
            this._srcPortEnd = base.getSrcPortEnd();
            this._srcPortStart = base.getSrcPortStart();
            this._tosByte = base.getTosByte();
            this._tosMask = base.getTosMask();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier.ExtClassifier>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier.ExtClassifier>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier.ExtClassifier>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier.ExtClassifier>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public Ipv4Address getDstIp() {
            return _dstIp;
        }
        
        @Override
        public Ipv4Address getDstIpMask() {
            return _dstIpMask;
        }
        
        @Override
        public PortNumber getDstPortEnd() {
            return _dstPortEnd;
        }
        
        @Override
        public PortNumber getDstPortStart() {
            return _dstPortStart;
        }
        
        @Override
        public TpProtocol getProtocol() {
            return _protocol;
        }
        
        @Override
        public Ipv4Address getSrcIp() {
            return _srcIp;
        }
        
        @Override
        public Ipv4Address getSrcIpMask() {
            return _srcIpMask;
        }
        
        @Override
        public PortNumber getSrcPortEnd() {
            return _srcPortEnd;
        }
        
        @Override
        public PortNumber getSrcPortStart() {
            return _srcPortStart;
        }
        
        @Override
        public TosByte getTosByte() {
            return _tosByte;
        }
        
        @Override
        public TosByte getTosMask() {
            return _tosMask;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier.ExtClassifier>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_dstIp == null) ? 0 : _dstIp.hashCode());
            result = prime * result + ((_dstIpMask == null) ? 0 : _dstIpMask.hashCode());
            result = prime * result + ((_dstPortEnd == null) ? 0 : _dstPortEnd.hashCode());
            result = prime * result + ((_dstPortStart == null) ? 0 : _dstPortStart.hashCode());
            result = prime * result + ((_protocol == null) ? 0 : _protocol.hashCode());
            result = prime * result + ((_srcIp == null) ? 0 : _srcIp.hashCode());
            result = prime * result + ((_srcIpMask == null) ? 0 : _srcIpMask.hashCode());
            result = prime * result + ((_srcPortEnd == null) ? 0 : _srcPortEnd.hashCode());
            result = prime * result + ((_srcPortStart == null) ? 0 : _srcPortStart.hashCode());
            result = prime * result + ((_tosByte == null) ? 0 : _tosByte.hashCode());
            result = prime * result + ((_tosMask == null) ? 0 : _tosMask.hashCode());
            result = prime * result + ((augmentation == null) ? 0 : augmentation.hashCode());
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier.ExtClassifier.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier.ExtClassifier other = (org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier.ExtClassifier)obj;
            if (_dstIp == null) {
                if (other.getDstIp() != null) {
                    return false;
                }
            } else if(!_dstIp.equals(other.getDstIp())) {
                return false;
            }
            if (_dstIpMask == null) {
                if (other.getDstIpMask() != null) {
                    return false;
                }
            } else if(!_dstIpMask.equals(other.getDstIpMask())) {
                return false;
            }
            if (_dstPortEnd == null) {
                if (other.getDstPortEnd() != null) {
                    return false;
                }
            } else if(!_dstPortEnd.equals(other.getDstPortEnd())) {
                return false;
            }
            if (_dstPortStart == null) {
                if (other.getDstPortStart() != null) {
                    return false;
                }
            } else if(!_dstPortStart.equals(other.getDstPortStart())) {
                return false;
            }
            if (_protocol == null) {
                if (other.getProtocol() != null) {
                    return false;
                }
            } else if(!_protocol.equals(other.getProtocol())) {
                return false;
            }
            if (_srcIp == null) {
                if (other.getSrcIp() != null) {
                    return false;
                }
            } else if(!_srcIp.equals(other.getSrcIp())) {
                return false;
            }
            if (_srcIpMask == null) {
                if (other.getSrcIpMask() != null) {
                    return false;
                }
            } else if(!_srcIpMask.equals(other.getSrcIpMask())) {
                return false;
            }
            if (_srcPortEnd == null) {
                if (other.getSrcPortEnd() != null) {
                    return false;
                }
            } else if(!_srcPortEnd.equals(other.getSrcPortEnd())) {
                return false;
            }
            if (_srcPortStart == null) {
                if (other.getSrcPortStart() != null) {
                    return false;
                }
            } else if(!_srcPortStart.equals(other.getSrcPortStart())) {
                return false;
            }
            if (_tosByte == null) {
                if (other.getTosByte() != null) {
                    return false;
                }
            } else if(!_tosByte.equals(other.getTosByte())) {
                return false;
            }
            if (_tosMask == null) {
                if (other.getTosMask() != null) {
                    return false;
                }
            } else if(!_tosMask.equals(other.getTosMask())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                ExtClassifierImpl otherImpl = (ExtClassifierImpl) obj;
                if (augmentation == null) {
                    if (otherImpl.augmentation != null) {
                        return false;
                    }
                } else if(!augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier.ExtClassifier>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier.ExtClassifier>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("ExtClassifier [");
            boolean first = true;
        
            if (_dstIp != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dstIp=");
                builder.append(_dstIp);
             }
            if (_dstIpMask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dstIpMask=");
                builder.append(_dstIpMask);
             }
            if (_dstPortEnd != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dstPortEnd=");
                builder.append(_dstPortEnd);
             }
            if (_dstPortStart != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dstPortStart=");
                builder.append(_dstPortStart);
             }
            if (_protocol != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_protocol=");
                builder.append(_protocol);
             }
            if (_srcIp != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_srcIp=");
                builder.append(_srcIp);
             }
            if (_srcIpMask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_srcIpMask=");
                builder.append(_srcIpMask);
             }
            if (_srcPortEnd != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_srcPortEnd=");
                builder.append(_srcPortEnd);
             }
            if (_srcPortStart != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_srcPortStart=");
                builder.append(_srcPortStart);
             }
            if (_tosByte != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tosByte=");
                builder.append(_tosByte);
             }
            if (_tosMask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tosMask=");
                builder.append(_tosMask);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
