package org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TosByte;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TpPortMatchRanges;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosExtClassifier;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TpProtocol;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Address;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * &lt;p&gt;This class represents the following YANG schema fragment defined in module &lt;b&gt;packetcable&lt;/b&gt;
 * &lt;br&gt;(Source path: &lt;i&gt;META-INF/yang/packetcable.yang&lt;/i&gt;):
 * &lt;pre&gt;
 * container ext-classifier {
 *     leaf srcIp {
 *         type ipv4-address;
 *     }
 *     leaf srcIpMask {
 *         type ipv4-address;
 *     }
 *     leaf dstIp {
 *         type ipv4-address;
 *     }
 *     leaf dstIpMask {
 *         type ipv4-address;
 *     }
 *     leaf tos-byte {
 *         type tos-byte;
 *     }
 *     leaf tos-mask {
 *         type tos-byte;
 *     }
 *     leaf protocol {
 *         type tp-protocol;
 *     }
 *     leaf srcPort-start {
 *         type port-number;
 *     }
 *     leaf srcPort-end {
 *         type port-number;
 *     }
 *     leaf dstPort-start {
 *         type port-number;
 *     }
 *     leaf dstPort-end {
 *         type port-number;
 *     }
 *     uses tp-port-match-ranges;
 * }
 * &lt;/pre&gt;
 * The schema path to identify an instance is
 * &lt;i&gt;packetcable/pcmm-qos-ext-classifier/ext-classifier&lt;/i&gt;
 *
 * &lt;p&gt;To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier.ExtClassifierBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier.ExtClassifierBuilder
 *
 */
public interface ExtClassifier
    extends
    ChildOf<PcmmQosExtClassifier>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier.ExtClassifier>,
    TpPortMatchRanges
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.cachedReference(org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable","2015-03-27","ext-classifier"));

    /**
     * Source IPv4 address match
     *
     */
    Ipv4Address getSrcIp();
    
    /**
     * Source IPv4 mask
     *
     */
    Ipv4Address getSrcIpMask();
    
    /**
     * Destination IPv4 address match
     *
     */
    Ipv4Address getDstIp();
    
    /**
     * Destination IPv4 mask
     *
     */
    Ipv4Address getDstIpMask();
    
    /**
     * TOS/DSCP match
     *
     */
    TosByte getTosByte();
    
    /**
     * TOS/DSCP mask
     *
     */
    TosByte getTosMask();
    
    /**
     * IPv4 transport protocol
     *
     */
    TpProtocol getProtocol();

}

