package org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.CcapAttributes;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * &lt;p&gt;This class represents the following YANG schema fragment defined in module &lt;b&gt;packetcable&lt;/b&gt;
 * &lt;br&gt;(Source path: &lt;i&gt;META-INF/yang/packetcable.yang&lt;/i&gt;):
 * &lt;pre&gt;
 * container amId {
 *     leaf am-tag {
 *         type uint16;
 *     }
 *     leaf am-type {
 *         type uint16;
 *     }
 * }
 * &lt;/pre&gt;
 * The schema path to identify an instance is
 * &lt;i&gt;packetcable/ccap-attributes/amId&lt;/i&gt;
 *
 * &lt;p&gt;To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.AmIdBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.AmIdBuilder
 *
 */
public interface AmId
    extends
    ChildOf<CcapAttributes>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.AmId>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.cachedReference(org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable","2015-03-27","amId"));

    /**
     * Application Manager Tag -- unique for this operator
     *
     */
    java.lang.Integer getAmTag();
    
    /**
     * Application Manager Type -- unique for this AM tag
     *
     */
    java.lang.Integer getAmType();

}

