package org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap;
import java.util.Collections;
import java.util.Map;
import java.util.HashMap;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ServiceClassName;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.IpPrefix;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.Connection;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.AmId;
import org.opendaylight.yangtools.yang.binding.Augmentation;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.Ccaps} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.Ccaps
 *
 */
public class CcapsBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.Ccaps> {

    private AmId _amId;
    private java.lang.String _ccapId;
    private Connection _connection;
    private List<ServiceClassName> _downstreamScns;
    private CcapsKey _key;
    private List<IpPrefix> _subscriberSubnets;
    private List<ServiceClassName> _upstreamScns;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.Ccaps>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.Ccaps>> augmentation = Collections.emptyMap();

    public CcapsBuilder() {
    }
    public CcapsBuilder(org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.CcapAttributes arg) {
        this._connection = arg.getConnection();
        this._amId = arg.getAmId();
        this._subscriberSubnets = arg.getSubscriberSubnets();
        this._upstreamScns = arg.getUpstreamScns();
        this._downstreamScns = arg.getDownstreamScns();
    }

    public CcapsBuilder(Ccaps base) {
        if (base.getKey() == null) {
            this._key = new CcapsKey(
                base.getCcapId()
            );
            this._ccapId = base.getCcapId();
        } else {
            this._key = base.getKey();
            this._ccapId = _key.getCcapId();
        }
        this._amId = base.getAmId();
        this._connection = base.getConnection();
        this._downstreamScns = base.getDownstreamScns();
        this._subscriberSubnets = base.getSubscriberSubnets();
        this._upstreamScns = base.getUpstreamScns();
        if (base instanceof CcapsImpl) {
            CcapsImpl impl = (CcapsImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.Ccaps> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.Ccaps>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.CcapAttributes</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.CcapAttributes) {
            this._connection = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.CcapAttributes)arg).getConnection();
            this._amId = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.CcapAttributes)arg).getAmId();
            this._subscriberSubnets = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.CcapAttributes)arg).getSubscriberSubnets();
            this._upstreamScns = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.CcapAttributes)arg).getUpstreamScns();
            this._downstreamScns = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.CcapAttributes)arg).getDownstreamScns();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.CcapAttributes] \n" +
              "but was: " + arg
            );
        }
    }

    public AmId getAmId() {
        return _amId;
    }
    
    public java.lang.String getCcapId() {
        return _ccapId;
    }
    
    public Connection getConnection() {
        return _connection;
    }
    
    public List<ServiceClassName> getDownstreamScns() {
        return _downstreamScns;
    }
    
    public CcapsKey getKey() {
        return _key;
    }
    
    public List<IpPrefix> getSubscriberSubnets() {
        return _subscriberSubnets;
    }
    
    public List<ServiceClassName> getUpstreamScns() {
        return _upstreamScns;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.Ccaps>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

    public CcapsBuilder setAmId(AmId value) {
        this._amId = value;
        return this;
    }
    
    public CcapsBuilder setCcapId(java.lang.String value) {
        this._ccapId = value;
        return this;
    }
    
    public CcapsBuilder setConnection(Connection value) {
        this._connection = value;
        return this;
    }
    
    public CcapsBuilder setDownstreamScns(List<ServiceClassName> value) {
        this._downstreamScns = value;
        return this;
    }
    
    public CcapsBuilder setKey(CcapsKey value) {
        this._key = value;
        return this;
    }
    
    public CcapsBuilder setSubscriberSubnets(List<IpPrefix> value) {
        this._subscriberSubnets = value;
        return this;
    }
    
    public CcapsBuilder setUpstreamScns(List<ServiceClassName> value) {
        this._upstreamScns = value;
        return this;
    }
    
    public CcapsBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.Ccaps>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.Ccaps> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public CcapsBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.Ccaps>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Ccaps build() {
        return new CcapsImpl(this);
    }

    private static final class CcapsImpl implements Ccaps {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.Ccaps> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.Ccaps.class;
        }

        private final AmId _amId;
        private final java.lang.String _ccapId;
        private final Connection _connection;
        private final List<ServiceClassName> _downstreamScns;
        private final CcapsKey _key;
        private final List<IpPrefix> _subscriberSubnets;
        private final List<ServiceClassName> _upstreamScns;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.Ccaps>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.Ccaps>> augmentation = Collections.emptyMap();

        private CcapsImpl(CcapsBuilder base) {
            if (base.getKey() == null) {
                this._key = new CcapsKey(
                    base.getCcapId()
                );
                this._ccapId = base.getCcapId();
            } else {
                this._key = base.getKey();
                this._ccapId = _key.getCcapId();
            }
            this._amId = base.getAmId();
            this._connection = base.getConnection();
            this._downstreamScns = base.getDownstreamScns();
            this._subscriberSubnets = base.getSubscriberSubnets();
            this._upstreamScns = base.getUpstreamScns();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.Ccaps>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.Ccaps>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.Ccaps>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.Ccaps>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public AmId getAmId() {
            return _amId;
        }
        
        @Override
        public java.lang.String getCcapId() {
            return _ccapId;
        }
        
        @Override
        public Connection getConnection() {
            return _connection;
        }
        
        @Override
        public List<ServiceClassName> getDownstreamScns() {
            return _downstreamScns;
        }
        
        @Override
        public CcapsKey getKey() {
            return _key;
        }
        
        @Override
        public List<IpPrefix> getSubscriberSubnets() {
            return _subscriberSubnets;
        }
        
        @Override
        public List<ServiceClassName> getUpstreamScns() {
            return _upstreamScns;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.Ccaps>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_amId == null) ? 0 : _amId.hashCode());
            result = prime * result + ((_ccapId == null) ? 0 : _ccapId.hashCode());
            result = prime * result + ((_connection == null) ? 0 : _connection.hashCode());
            result = prime * result + ((_downstreamScns == null) ? 0 : _downstreamScns.hashCode());
            result = prime * result + ((_key == null) ? 0 : _key.hashCode());
            result = prime * result + ((_subscriberSubnets == null) ? 0 : _subscriberSubnets.hashCode());
            result = prime * result + ((_upstreamScns == null) ? 0 : _upstreamScns.hashCode());
            result = prime * result + ((augmentation == null) ? 0 : augmentation.hashCode());
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.Ccaps.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.Ccaps other = (org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.Ccaps)obj;
            if (_amId == null) {
                if (other.getAmId() != null) {
                    return false;
                }
            } else if(!_amId.equals(other.getAmId())) {
                return false;
            }
            if (_ccapId == null) {
                if (other.getCcapId() != null) {
                    return false;
                }
            } else if(!_ccapId.equals(other.getCcapId())) {
                return false;
            }
            if (_connection == null) {
                if (other.getConnection() != null) {
                    return false;
                }
            } else if(!_connection.equals(other.getConnection())) {
                return false;
            }
            if (_downstreamScns == null) {
                if (other.getDownstreamScns() != null) {
                    return false;
                }
            } else if(!_downstreamScns.equals(other.getDownstreamScns())) {
                return false;
            }
            if (_key == null) {
                if (other.getKey() != null) {
                    return false;
                }
            } else if(!_key.equals(other.getKey())) {
                return false;
            }
            if (_subscriberSubnets == null) {
                if (other.getSubscriberSubnets() != null) {
                    return false;
                }
            } else if(!_subscriberSubnets.equals(other.getSubscriberSubnets())) {
                return false;
            }
            if (_upstreamScns == null) {
                if (other.getUpstreamScns() != null) {
                    return false;
                }
            } else if(!_upstreamScns.equals(other.getUpstreamScns())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                CcapsImpl otherImpl = (CcapsImpl) obj;
                if (augmentation == null) {
                    if (otherImpl.augmentation != null) {
                        return false;
                    }
                } else if(!augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.Ccaps>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.Ccaps>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("Ccaps [");
            boolean first = true;
        
            if (_amId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_amId=");
                builder.append(_amId);
             }
            if (_ccapId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ccapId=");
                builder.append(_ccapId);
             }
            if (_connection != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_connection=");
                builder.append(_connection);
             }
            if (_downstreamScns != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_downstreamScns=");
                builder.append(_downstreamScns);
             }
            if (_key != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_key=");
                builder.append(_key);
             }
            if (_subscriberSubnets != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_subscriberSubnets=");
                builder.append(_subscriberSubnets);
             }
            if (_upstreamScns != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_upstreamScns=");
                builder.append(_upstreamScns);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
