package org.opendaylight.yang.gen.v1.urn.packetcable.rev150327;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier.Ipv6Classifier;


/**
 * &lt;p&gt;This class represents the following YANG schema fragment defined in module &lt;b&gt;packetcable&lt;/b&gt;
 * &lt;br&gt;(Source path: &lt;i&gt;META-INF/yang/packetcable.yang&lt;/i&gt;):
 * &lt;pre&gt;
 * grouping pcmm-qos-ipv6-classifier {
 *     container ipv6-classifier {
 *         leaf srcIp6 {
 *             type ipv6-prefix;
 *         }
 *         leaf dstIp6 {
 *             type ipv6-prefix;
 *         }
 *         leaf tc-low {
 *             type tos-byte;
 *         }
 *         leaf tc-high {
 *             type tos-byte;
 *         }
 *         leaf tc-mask {
 *             type tos-byte;
 *         }
 *         leaf next-hdr {
 *             type tp-protocol;
 *         }
 *         leaf flow-label {
 *             type uint32;
 *         }
 *         leaf srcPort-start {
 *             type port-number;
 *         }
 *         leaf srcPort-end {
 *             type port-number;
 *         }
 *         leaf dstPort-start {
 *             type port-number;
 *         }
 *         leaf dstPort-end {
 *             type port-number;
 *         }
 *         uses tp-port-match-ranges;
 *     }
 * }
 * &lt;/pre&gt;
 * The schema path to identify an instance is
 * &lt;i&gt;packetcable/pcmm-qos-ipv6-classifier&lt;/i&gt;
 *
 */
public interface PcmmQosIpv6Classifier
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.cachedReference(org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable","2015-03-27","pcmm-qos-ipv6-classifier"));

    Ipv6Classifier getIpv6Classifier();

}

