package org.opendaylight.yang.gen.v1.urn.packetcable.rev150327;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier.ExtClassifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.DataObject;


/**
 * &lt;p&gt;This class represents the following YANG schema fragment defined in module &lt;b&gt;packetcable&lt;/b&gt;
 * &lt;br&gt;(Source path: &lt;i&gt;META-INF/yang/packetcable.yang&lt;/i&gt;):
 * &lt;pre&gt;
 * grouping pcmm-qos-ext-classifier {
 *     container ext-classifier {
 *         leaf srcIp {
 *             type ipv4-address;
 *         }
 *         leaf srcIpMask {
 *             type ipv4-address;
 *         }
 *         leaf dstIp {
 *             type ipv4-address;
 *         }
 *         leaf dstIpMask {
 *             type ipv4-address;
 *         }
 *         leaf tos-byte {
 *             type tos-byte;
 *         }
 *         leaf tos-mask {
 *             type tos-byte;
 *         }
 *         leaf protocol {
 *             type tp-protocol;
 *         }
 *         leaf srcPort-start {
 *             type port-number;
 *         }
 *         leaf srcPort-end {
 *             type port-number;
 *         }
 *         leaf dstPort-start {
 *             type port-number;
 *         }
 *         leaf dstPort-end {
 *             type port-number;
 *         }
 *         uses tp-port-match-ranges;
 *     }
 * }
 * &lt;/pre&gt;
 * The schema path to identify an instance is
 * &lt;i&gt;packetcable/pcmm-qos-ext-classifier&lt;/i&gt;
 *
 */
public interface PcmmQosExtClassifier
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.cachedReference(org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable","2015-03-27","pcmm-qos-ext-classifier"));

    ExtClassifier getExtClassifier();

}

