/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.traffic.profile;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ServiceClassName;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.traffic.profile.TrafficProfile;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TrafficProfileBuilder
implements Builder<TrafficProfile> {
    private ServiceClassName _serviceClassName;
    Map<Class<? extends Augmentation<TrafficProfile>>, Augmentation<TrafficProfile>> augmentation = Collections.emptyMap();

    private static void check_serviceClassNameLength(String value) {
        int length = value.length();
        if (length >= 2 && length <= 16) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid length: %s, expected: [[2\u202516]].", value));
    }

    public TrafficProfileBuilder() {
    }

    public TrafficProfileBuilder(TrafficProfile base) {
        AugmentationHolder casted;
        this._serviceClassName = base.getServiceClassName();
        if (base instanceof TrafficProfileImpl) {
            TrafficProfileImpl impl = (TrafficProfileImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<TrafficProfile>>, Augmentation<TrafficProfile>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TrafficProfile>>, Augmentation<TrafficProfile>>(casted.augmentations());
        }
    }

    public ServiceClassName getServiceClassName() {
        return this._serviceClassName;
    }

    public <E extends Augmentation<TrafficProfile>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public TrafficProfileBuilder setServiceClassName(ServiceClassName value) {
        if (value != null) {
            TrafficProfileBuilder.check_serviceClassNameLength(value.getValue());
        }
        this._serviceClassName = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _serviceClassName_length() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.valueOf(2L), (Comparable)BigInteger.valueOf(16L)));
        return ret;
    }

    public TrafficProfileBuilder addAugmentation(Class<? extends Augmentation<TrafficProfile>> augmentationType, Augmentation<TrafficProfile> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TrafficProfile>>, Augmentation<TrafficProfile>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public TrafficProfileBuilder removeAugmentation(Class<? extends Augmentation<TrafficProfile>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public TrafficProfile build() {
        return new TrafficProfileImpl(this);
    }

    private static final class TrafficProfileImpl
    implements TrafficProfile {
        private final ServiceClassName _serviceClassName;
        private Map<Class<? extends Augmentation<TrafficProfile>>, Augmentation<TrafficProfile>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<TrafficProfile> getImplementedInterface() {
            return TrafficProfile.class;
        }

        private TrafficProfileImpl(TrafficProfileBuilder base) {
            this._serviceClassName = base.getServiceClassName();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<TrafficProfile>>, Augmentation<TrafficProfile>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<TrafficProfile>>, Augmentation<TrafficProfile>>(base.augmentation);
                }
            }
        }

        @Override
        public ServiceClassName getServiceClassName() {
            return this._serviceClassName;
        }

        public <E extends Augmentation<TrafficProfile>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._serviceClassName == null ? 0 : this._serviceClassName.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!TrafficProfile.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            TrafficProfile other = (TrafficProfile)obj;
            if (this._serviceClassName == null ? other.getServiceClassName() != null : !this._serviceClassName.equals(other.getServiceClassName())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TrafficProfileImpl otherImpl = (TrafficProfileImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<TrafficProfile>>, Augmentation<TrafficProfile>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("TrafficProfile [");
            boolean first = true;
            if (this._serviceClassName != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_serviceClassName=");
                builder.append(this._serviceClassName);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

