/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv6Prefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.PortNumber;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TosByte;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TpPortMatchRanges;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TpProtocol;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier.Ipv6Classifier;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class Ipv6ClassifierBuilder
implements Builder<Ipv6Classifier> {
    private Ipv6Prefix _dstIp6;
    private PortNumber _dstPortEnd;
    private PortNumber _dstPortStart;
    private Long _flowLabel;
    private TpProtocol _nextHdr;
    private Ipv6Prefix _srcIp6;
    private PortNumber _srcPortEnd;
    private PortNumber _srcPortStart;
    private TosByte _tcHigh;
    private TosByte _tcLow;
    private TosByte _tcMask;
    Map<Class<? extends Augmentation<Ipv6Classifier>>, Augmentation<Ipv6Classifier>> augmentation = Collections.emptyMap();

    public Ipv6ClassifierBuilder() {
    }

    public Ipv6ClassifierBuilder(TpPortMatchRanges arg) {
        this._srcPortStart = arg.getSrcPortStart();
        this._srcPortEnd = arg.getSrcPortEnd();
        this._dstPortStart = arg.getDstPortStart();
        this._dstPortEnd = arg.getDstPortEnd();
    }

    public Ipv6ClassifierBuilder(Ipv6Classifier base) {
        AugmentationHolder casted;
        this._dstIp6 = base.getDstIp6();
        this._dstPortEnd = base.getDstPortEnd();
        this._dstPortStart = base.getDstPortStart();
        this._flowLabel = base.getFlowLabel();
        this._nextHdr = base.getNextHdr();
        this._srcIp6 = base.getSrcIp6();
        this._srcPortEnd = base.getSrcPortEnd();
        this._srcPortStart = base.getSrcPortStart();
        this._tcHigh = base.getTcHigh();
        this._tcLow = base.getTcLow();
        this._tcMask = base.getTcMask();
        if (base instanceof Ipv6ClassifierImpl) {
            Ipv6ClassifierImpl impl = (Ipv6ClassifierImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Ipv6Classifier>>, Augmentation<Ipv6Classifier>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ipv6Classifier>>, Augmentation<Ipv6Classifier>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof TpPortMatchRanges) {
            this._srcPortStart = ((TpPortMatchRanges)arg).getSrcPortStart();
            this._srcPortEnd = ((TpPortMatchRanges)arg).getSrcPortEnd();
            this._dstPortStart = ((TpPortMatchRanges)arg).getDstPortStart();
            this._dstPortEnd = ((TpPortMatchRanges)arg).getDstPortEnd();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TpPortMatchRanges] \nbut was: " + arg);
        }
    }

    public Ipv6Prefix getDstIp6() {
        return this._dstIp6;
    }

    public PortNumber getDstPortEnd() {
        return this._dstPortEnd;
    }

    public PortNumber getDstPortStart() {
        return this._dstPortStart;
    }

    public Long getFlowLabel() {
        return this._flowLabel;
    }

    public TpProtocol getNextHdr() {
        return this._nextHdr;
    }

    public Ipv6Prefix getSrcIp6() {
        return this._srcIp6;
    }

    public PortNumber getSrcPortEnd() {
        return this._srcPortEnd;
    }

    public PortNumber getSrcPortStart() {
        return this._srcPortStart;
    }

    public TosByte getTcHigh() {
        return this._tcHigh;
    }

    public TosByte getTcLow() {
        return this._tcLow;
    }

    public TosByte getTcMask() {
        return this._tcMask;
    }

    public <E extends Augmentation<Ipv6Classifier>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public Ipv6ClassifierBuilder setDstIp6(Ipv6Prefix value) {
        if (value != null) {
            // empty if block
        }
        this._dstIp6 = value;
        return this;
    }

    private static void checkDstPortEndRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public Ipv6ClassifierBuilder setDstPortEnd(PortNumber value) {
        if (value != null) {
            Ipv6ClassifierBuilder.checkDstPortEndRange(value.getValue());
        }
        this._dstPortEnd = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _dstPortEnd_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }

    private static void checkDstPortStartRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public Ipv6ClassifierBuilder setDstPortStart(PortNumber value) {
        if (value != null) {
            Ipv6ClassifierBuilder.checkDstPortStartRange(value.getValue());
        }
        this._dstPortStart = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _dstPortStart_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }

    private static void checkFlowLabelRange(long value) {
        if (value >= 0L && value <= 1048575L) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20251048575]].", value));
    }

    public Ipv6ClassifierBuilder setFlowLabel(Long value) {
        if (value != null) {
            Ipv6ClassifierBuilder.checkFlowLabelRange(value);
        }
        this._flowLabel = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _flowLabel_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(1048575L)));
        return ret;
    }

    private static void checkNextHdrRange(int value) {
        if (value >= 0 && value <= 257) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025257]].", value));
    }

    public Ipv6ClassifierBuilder setNextHdr(TpProtocol value) {
        if (value != null) {
            Ipv6ClassifierBuilder.checkNextHdrRange(value.getValue());
        }
        this._nextHdr = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _nextHdr_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(257L)));
        return ret;
    }

    public Ipv6ClassifierBuilder setSrcIp6(Ipv6Prefix value) {
        if (value != null) {
            // empty if block
        }
        this._srcIp6 = value;
        return this;
    }

    private static void checkSrcPortEndRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public Ipv6ClassifierBuilder setSrcPortEnd(PortNumber value) {
        if (value != null) {
            Ipv6ClassifierBuilder.checkSrcPortEndRange(value.getValue());
        }
        this._srcPortEnd = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _srcPortEnd_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }

    private static void checkSrcPortStartRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public Ipv6ClassifierBuilder setSrcPortStart(PortNumber value) {
        if (value != null) {
            Ipv6ClassifierBuilder.checkSrcPortStartRange(value.getValue());
        }
        this._srcPortStart = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _srcPortStart_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }

    private static void checkTcHighRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public Ipv6ClassifierBuilder setTcHigh(TosByte value) {
        if (value != null) {
            Ipv6ClassifierBuilder.checkTcHighRange(value.getValue());
        }
        this._tcHigh = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _tcHigh_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
        return ret;
    }

    private static void checkTcLowRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public Ipv6ClassifierBuilder setTcLow(TosByte value) {
        if (value != null) {
            Ipv6ClassifierBuilder.checkTcLowRange(value.getValue());
        }
        this._tcLow = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _tcLow_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
        return ret;
    }

    private static void checkTcMaskRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public Ipv6ClassifierBuilder setTcMask(TosByte value) {
        if (value != null) {
            Ipv6ClassifierBuilder.checkTcMaskRange(value.getValue());
        }
        this._tcMask = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _tcMask_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
        return ret;
    }

    public Ipv6ClassifierBuilder addAugmentation(Class<? extends Augmentation<Ipv6Classifier>> augmentationType, Augmentation<Ipv6Classifier> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ipv6Classifier>>, Augmentation<Ipv6Classifier>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Ipv6ClassifierBuilder removeAugmentation(Class<? extends Augmentation<Ipv6Classifier>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Ipv6Classifier build() {
        return new Ipv6ClassifierImpl(this);
    }

    private static final class Ipv6ClassifierImpl
    implements Ipv6Classifier {
        private final Ipv6Prefix _dstIp6;
        private final PortNumber _dstPortEnd;
        private final PortNumber _dstPortStart;
        private final Long _flowLabel;
        private final TpProtocol _nextHdr;
        private final Ipv6Prefix _srcIp6;
        private final PortNumber _srcPortEnd;
        private final PortNumber _srcPortStart;
        private final TosByte _tcHigh;
        private final TosByte _tcLow;
        private final TosByte _tcMask;
        private Map<Class<? extends Augmentation<Ipv6Classifier>>, Augmentation<Ipv6Classifier>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Ipv6Classifier> getImplementedInterface() {
            return Ipv6Classifier.class;
        }

        private Ipv6ClassifierImpl(Ipv6ClassifierBuilder base) {
            this._dstIp6 = base.getDstIp6();
            this._dstPortEnd = base.getDstPortEnd();
            this._dstPortStart = base.getDstPortStart();
            this._flowLabel = base.getFlowLabel();
            this._nextHdr = base.getNextHdr();
            this._srcIp6 = base.getSrcIp6();
            this._srcPortEnd = base.getSrcPortEnd();
            this._srcPortStart = base.getSrcPortStart();
            this._tcHigh = base.getTcHigh();
            this._tcLow = base.getTcLow();
            this._tcMask = base.getTcMask();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Ipv6Classifier>>, Augmentation<Ipv6Classifier>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Ipv6Classifier>>, Augmentation<Ipv6Classifier>>(base.augmentation);
                }
            }
        }

        @Override
        public Ipv6Prefix getDstIp6() {
            return this._dstIp6;
        }

        @Override
        public PortNumber getDstPortEnd() {
            return this._dstPortEnd;
        }

        @Override
        public PortNumber getDstPortStart() {
            return this._dstPortStart;
        }

        @Override
        public Long getFlowLabel() {
            return this._flowLabel;
        }

        @Override
        public TpProtocol getNextHdr() {
            return this._nextHdr;
        }

        @Override
        public Ipv6Prefix getSrcIp6() {
            return this._srcIp6;
        }

        @Override
        public PortNumber getSrcPortEnd() {
            return this._srcPortEnd;
        }

        @Override
        public PortNumber getSrcPortStart() {
            return this._srcPortStart;
        }

        @Override
        public TosByte getTcHigh() {
            return this._tcHigh;
        }

        @Override
        public TosByte getTcLow() {
            return this._tcLow;
        }

        @Override
        public TosByte getTcMask() {
            return this._tcMask;
        }

        public <E extends Augmentation<Ipv6Classifier>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._dstIp6 == null ? 0 : this._dstIp6.hashCode());
            result = 31 * result + (this._dstPortEnd == null ? 0 : this._dstPortEnd.hashCode());
            result = 31 * result + (this._dstPortStart == null ? 0 : this._dstPortStart.hashCode());
            result = 31 * result + (this._flowLabel == null ? 0 : this._flowLabel.hashCode());
            result = 31 * result + (this._nextHdr == null ? 0 : this._nextHdr.hashCode());
            result = 31 * result + (this._srcIp6 == null ? 0 : this._srcIp6.hashCode());
            result = 31 * result + (this._srcPortEnd == null ? 0 : this._srcPortEnd.hashCode());
            result = 31 * result + (this._srcPortStart == null ? 0 : this._srcPortStart.hashCode());
            result = 31 * result + (this._tcHigh == null ? 0 : this._tcHigh.hashCode());
            result = 31 * result + (this._tcLow == null ? 0 : this._tcLow.hashCode());
            result = 31 * result + (this._tcMask == null ? 0 : this._tcMask.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Ipv6Classifier.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Ipv6Classifier other = (Ipv6Classifier)obj;
            if (this._dstIp6 == null ? other.getDstIp6() != null : !this._dstIp6.equals((Object)other.getDstIp6())) {
                return false;
            }
            if (this._dstPortEnd == null ? other.getDstPortEnd() != null : !this._dstPortEnd.equals((Object)other.getDstPortEnd())) {
                return false;
            }
            if (this._dstPortStart == null ? other.getDstPortStart() != null : !this._dstPortStart.equals((Object)other.getDstPortStart())) {
                return false;
            }
            if (this._flowLabel == null ? other.getFlowLabel() != null : !this._flowLabel.equals(other.getFlowLabel())) {
                return false;
            }
            if (this._nextHdr == null ? other.getNextHdr() != null : !this._nextHdr.equals(other.getNextHdr())) {
                return false;
            }
            if (this._srcIp6 == null ? other.getSrcIp6() != null : !this._srcIp6.equals((Object)other.getSrcIp6())) {
                return false;
            }
            if (this._srcPortEnd == null ? other.getSrcPortEnd() != null : !this._srcPortEnd.equals((Object)other.getSrcPortEnd())) {
                return false;
            }
            if (this._srcPortStart == null ? other.getSrcPortStart() != null : !this._srcPortStart.equals((Object)other.getSrcPortStart())) {
                return false;
            }
            if (this._tcHigh == null ? other.getTcHigh() != null : !this._tcHigh.equals(other.getTcHigh())) {
                return false;
            }
            if (this._tcLow == null ? other.getTcLow() != null : !this._tcLow.equals(other.getTcLow())) {
                return false;
            }
            if (this._tcMask == null ? other.getTcMask() != null : !this._tcMask.equals(other.getTcMask())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                Ipv6ClassifierImpl otherImpl = (Ipv6ClassifierImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Ipv6Classifier>>, Augmentation<Ipv6Classifier>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Ipv6Classifier [");
            boolean first = true;
            if (this._dstIp6 != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dstIp6=");
                builder.append(this._dstIp6);
            }
            if (this._dstPortEnd != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dstPortEnd=");
                builder.append(this._dstPortEnd);
            }
            if (this._dstPortStart != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dstPortStart=");
                builder.append(this._dstPortStart);
            }
            if (this._flowLabel != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_flowLabel=");
                builder.append(this._flowLabel);
            }
            if (this._nextHdr != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nextHdr=");
                builder.append(this._nextHdr);
            }
            if (this._srcIp6 != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_srcIp6=");
                builder.append(this._srcIp6);
            }
            if (this._srcPortEnd != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_srcPortEnd=");
                builder.append(this._srcPortEnd);
            }
            if (this._srcPortStart != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_srcPortStart=");
                builder.append(this._srcPortStart);
            }
            if (this._tcHigh != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tcHigh=");
                builder.append(this._tcHigh);
            }
            if (this._tcLow != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tcLow=");
                builder.append(this._tcLow);
            }
            if (this._tcMask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tcMask=");
                builder.append(this._tcMask);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

