/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.Apps;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.AppsKey;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.Subs;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class AppsBuilder
implements Builder<Apps> {
    private String _appId;
    private AppsKey _key;
    private List<Subs> _subs;
    Map<Class<? extends Augmentation<Apps>>, Augmentation<Apps>> augmentation = Collections.emptyMap();

    public AppsBuilder() {
    }

    public AppsBuilder(Apps base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new AppsKey(base.getAppId());
            this._appId = base.getAppId();
        } else {
            this._key = base.getKey();
            this._appId = this._key.getAppId();
        }
        this._subs = base.getSubs();
        if (base instanceof AppsImpl) {
            AppsImpl impl = (AppsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Apps>>, Augmentation<Apps>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Apps>>, Augmentation<Apps>>(casted.augmentations());
        }
    }

    public String getAppId() {
        return this._appId;
    }

    public AppsKey getKey() {
        return this._key;
    }

    public List<Subs> getSubs() {
        return this._subs;
    }

    public <E extends Augmentation<Apps>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public AppsBuilder setAppId(String value) {
        this._appId = value;
        return this;
    }

    public AppsBuilder setKey(AppsKey value) {
        this._key = value;
        return this;
    }

    public AppsBuilder setSubs(List<Subs> value) {
        this._subs = value;
        return this;
    }

    public AppsBuilder addAugmentation(Class<? extends Augmentation<Apps>> augmentationType, Augmentation<Apps> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Apps>>, Augmentation<Apps>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public AppsBuilder removeAugmentation(Class<? extends Augmentation<Apps>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Apps build() {
        return new AppsImpl(this);
    }

    private static final class AppsImpl
    implements Apps {
        private final String _appId;
        private final AppsKey _key;
        private final List<Subs> _subs;
        private Map<Class<? extends Augmentation<Apps>>, Augmentation<Apps>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Apps> getImplementedInterface() {
            return Apps.class;
        }

        private AppsImpl(AppsBuilder base) {
            if (base.getKey() == null) {
                this._key = new AppsKey(base.getAppId());
                this._appId = base.getAppId();
            } else {
                this._key = base.getKey();
                this._appId = this._key.getAppId();
            }
            this._subs = base.getSubs();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Apps>>, Augmentation<Apps>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Apps>>, Augmentation<Apps>>(base.augmentation);
                }
            }
        }

        @Override
        public String getAppId() {
            return this._appId;
        }

        @Override
        public AppsKey getKey() {
            return this._key;
        }

        @Override
        public List<Subs> getSubs() {
            return this._subs;
        }

        public <E extends Augmentation<Apps>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._appId == null ? 0 : this._appId.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this._subs == null ? 0 : this._subs.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Apps.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Apps other = (Apps)obj;
            if (this._appId == null ? other.getAppId() != null : !this._appId.equals(other.getAppId())) {
                return false;
            }
            if (this._key == null ? other.getKey() != null : !this._key.equals(other.getKey())) {
                return false;
            }
            if (this._subs == null ? other.getSubs() != null : !this._subs.equals(other.getSubs())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                AppsImpl otherImpl = (AppsImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Apps>>, Augmentation<Apps>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Apps [");
            boolean first = true;
            if (this._appId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_appId=");
                builder.append(this._appId);
            }
            if (this._key != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_key=");
                builder.append(this._key);
            }
            if (this._subs != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_subs=");
                builder.append(this._subs);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

