/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.classifier;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.PortNumber;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TosByte;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TpProtocol;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.classifier.Classifier;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ClassifierBuilder
implements Builder<Classifier> {
    private Ipv4Address _dstIp;
    private PortNumber _dstPort;
    private TpProtocol _protocol;
    private Ipv4Address _srcIp;
    private PortNumber _srcPort;
    private TosByte _tosByte;
    private TosByte _tosMask;
    Map<Class<? extends Augmentation<Classifier>>, Augmentation<Classifier>> augmentation = Collections.emptyMap();

    public ClassifierBuilder() {
    }

    public ClassifierBuilder(Classifier base) {
        AugmentationHolder casted;
        this._dstIp = base.getDstIp();
        this._dstPort = base.getDstPort();
        this._protocol = base.getProtocol();
        this._srcIp = base.getSrcIp();
        this._srcPort = base.getSrcPort();
        this._tosByte = base.getTosByte();
        this._tosMask = base.getTosMask();
        if (base instanceof ClassifierImpl) {
            ClassifierImpl impl = (ClassifierImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Classifier>>, Augmentation<Classifier>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Classifier>>, Augmentation<Classifier>>(casted.augmentations());
        }
    }

    public Ipv4Address getDstIp() {
        return this._dstIp;
    }

    public PortNumber getDstPort() {
        return this._dstPort;
    }

    public TpProtocol getProtocol() {
        return this._protocol;
    }

    public Ipv4Address getSrcIp() {
        return this._srcIp;
    }

    public PortNumber getSrcPort() {
        return this._srcPort;
    }

    public TosByte getTosByte() {
        return this._tosByte;
    }

    public TosByte getTosMask() {
        return this._tosMask;
    }

    public <E extends Augmentation<Classifier>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ClassifierBuilder setDstIp(Ipv4Address value) {
        if (value != null) {
            // empty if block
        }
        this._dstIp = value;
        return this;
    }

    private static void checkDstPortRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public ClassifierBuilder setDstPort(PortNumber value) {
        if (value != null) {
            ClassifierBuilder.checkDstPortRange(value.getValue());
        }
        this._dstPort = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _dstPort_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }

    private static void checkProtocolRange(int value) {
        if (value >= 0 && value <= 257) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025257]].", value));
    }

    public ClassifierBuilder setProtocol(TpProtocol value) {
        if (value != null) {
            ClassifierBuilder.checkProtocolRange(value.getValue());
        }
        this._protocol = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _protocol_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(257L)));
        return ret;
    }

    public ClassifierBuilder setSrcIp(Ipv4Address value) {
        if (value != null) {
            // empty if block
        }
        this._srcIp = value;
        return this;
    }

    private static void checkSrcPortRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public ClassifierBuilder setSrcPort(PortNumber value) {
        if (value != null) {
            ClassifierBuilder.checkSrcPortRange(value.getValue());
        }
        this._srcPort = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _srcPort_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }

    private static void checkTosByteRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public ClassifierBuilder setTosByte(TosByte value) {
        if (value != null) {
            ClassifierBuilder.checkTosByteRange(value.getValue());
        }
        this._tosByte = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _tosByte_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
        return ret;
    }

    private static void checkTosMaskRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public ClassifierBuilder setTosMask(TosByte value) {
        if (value != null) {
            ClassifierBuilder.checkTosMaskRange(value.getValue());
        }
        this._tosMask = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _tosMask_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
        return ret;
    }

    public ClassifierBuilder addAugmentation(Class<? extends Augmentation<Classifier>> augmentationType, Augmentation<Classifier> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Classifier>>, Augmentation<Classifier>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ClassifierBuilder removeAugmentation(Class<? extends Augmentation<Classifier>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Classifier build() {
        return new ClassifierImpl(this);
    }

    private static final class ClassifierImpl
    implements Classifier {
        private final Ipv4Address _dstIp;
        private final PortNumber _dstPort;
        private final TpProtocol _protocol;
        private final Ipv4Address _srcIp;
        private final PortNumber _srcPort;
        private final TosByte _tosByte;
        private final TosByte _tosMask;
        private Map<Class<? extends Augmentation<Classifier>>, Augmentation<Classifier>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Classifier> getImplementedInterface() {
            return Classifier.class;
        }

        private ClassifierImpl(ClassifierBuilder base) {
            this._dstIp = base.getDstIp();
            this._dstPort = base.getDstPort();
            this._protocol = base.getProtocol();
            this._srcIp = base.getSrcIp();
            this._srcPort = base.getSrcPort();
            this._tosByte = base.getTosByte();
            this._tosMask = base.getTosMask();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Classifier>>, Augmentation<Classifier>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Classifier>>, Augmentation<Classifier>>(base.augmentation);
                }
            }
        }

        @Override
        public Ipv4Address getDstIp() {
            return this._dstIp;
        }

        @Override
        public PortNumber getDstPort() {
            return this._dstPort;
        }

        @Override
        public TpProtocol getProtocol() {
            return this._protocol;
        }

        @Override
        public Ipv4Address getSrcIp() {
            return this._srcIp;
        }

        @Override
        public PortNumber getSrcPort() {
            return this._srcPort;
        }

        @Override
        public TosByte getTosByte() {
            return this._tosByte;
        }

        @Override
        public TosByte getTosMask() {
            return this._tosMask;
        }

        public <E extends Augmentation<Classifier>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._dstIp == null ? 0 : this._dstIp.hashCode());
            result = 31 * result + (this._dstPort == null ? 0 : this._dstPort.hashCode());
            result = 31 * result + (this._protocol == null ? 0 : this._protocol.hashCode());
            result = 31 * result + (this._srcIp == null ? 0 : this._srcIp.hashCode());
            result = 31 * result + (this._srcPort == null ? 0 : this._srcPort.hashCode());
            result = 31 * result + (this._tosByte == null ? 0 : this._tosByte.hashCode());
            result = 31 * result + (this._tosMask == null ? 0 : this._tosMask.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Classifier.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Classifier other = (Classifier)obj;
            if (this._dstIp == null ? other.getDstIp() != null : !this._dstIp.equals((Object)other.getDstIp())) {
                return false;
            }
            if (this._dstPort == null ? other.getDstPort() != null : !this._dstPort.equals((Object)other.getDstPort())) {
                return false;
            }
            if (this._protocol == null ? other.getProtocol() != null : !this._protocol.equals(other.getProtocol())) {
                return false;
            }
            if (this._srcIp == null ? other.getSrcIp() != null : !this._srcIp.equals((Object)other.getSrcIp())) {
                return false;
            }
            if (this._srcPort == null ? other.getSrcPort() != null : !this._srcPort.equals((Object)other.getSrcPort())) {
                return false;
            }
            if (this._tosByte == null ? other.getTosByte() != null : !this._tosByte.equals(other.getTosByte())) {
                return false;
            }
            if (this._tosMask == null ? other.getTosMask() != null : !this._tosMask.equals(other.getTosMask())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ClassifierImpl otherImpl = (ClassifierImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Classifier>>, Augmentation<Classifier>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Classifier [");
            boolean first = true;
            if (this._dstIp != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dstIp=");
                builder.append(this._dstIp);
            }
            if (this._dstPort != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dstPort=");
                builder.append(this._dstPort);
            }
            if (this._protocol != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_protocol=");
                builder.append(this._protocol);
            }
            if (this._srcIp != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_srcIp=");
                builder.append(this._srcIp);
            }
            if (this._srcPort != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_srcPort=");
                builder.append(this._srcPort);
            }
            if (this._tosByte != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tosByte=");
                builder.append(this._tosByte);
            }
            if (this._tosMask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tosMask=");
                builder.append(this._tosMask);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

