/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.PortNumber;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.Connection;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ConnectionBuilder
implements Builder<Connection> {
    private IpAddress _ipAddress;
    private PortNumber _port;
    Map<Class<? extends Augmentation<Connection>>, Augmentation<Connection>> augmentation = Collections.emptyMap();

    public ConnectionBuilder() {
    }

    public ConnectionBuilder(Connection base) {
        AugmentationHolder casted;
        this._ipAddress = base.getIpAddress();
        this._port = base.getPort();
        if (base instanceof ConnectionImpl) {
            ConnectionImpl impl = (ConnectionImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Connection>>, Augmentation<Connection>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Connection>>, Augmentation<Connection>>(casted.augmentations());
        }
    }

    public IpAddress getIpAddress() {
        return this._ipAddress;
    }

    public PortNumber getPort() {
        return this._port;
    }

    public <E extends Augmentation<Connection>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ConnectionBuilder setIpAddress(IpAddress value) {
        if (value != null) {
            // empty if block
        }
        this._ipAddress = value;
        return this;
    }

    private static void checkPortRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public ConnectionBuilder setPort(PortNumber value) {
        if (value != null) {
            ConnectionBuilder.checkPortRange(value.getValue());
        }
        this._port = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _port_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }

    public ConnectionBuilder addAugmentation(Class<? extends Augmentation<Connection>> augmentationType, Augmentation<Connection> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Connection>>, Augmentation<Connection>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ConnectionBuilder removeAugmentation(Class<? extends Augmentation<Connection>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Connection build() {
        return new ConnectionImpl(this);
    }

    private static final class ConnectionImpl
    implements Connection {
        private final IpAddress _ipAddress;
        private final PortNumber _port;
        private Map<Class<? extends Augmentation<Connection>>, Augmentation<Connection>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Connection> getImplementedInterface() {
            return Connection.class;
        }

        private ConnectionImpl(ConnectionBuilder base) {
            this._ipAddress = base.getIpAddress();
            this._port = base.getPort();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Connection>>, Augmentation<Connection>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Connection>>, Augmentation<Connection>>(base.augmentation);
                }
            }
        }

        @Override
        public IpAddress getIpAddress() {
            return this._ipAddress;
        }

        @Override
        public PortNumber getPort() {
            return this._port;
        }

        public <E extends Augmentation<Connection>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._ipAddress == null ? 0 : this._ipAddress.hashCode());
            result = 31 * result + (this._port == null ? 0 : this._port.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Connection.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Connection other = (Connection)obj;
            if (this._ipAddress == null ? other.getIpAddress() != null : !this._ipAddress.equals((Object)other.getIpAddress())) {
                return false;
            }
            if (this._port == null ? other.getPort() != null : !this._port.equals((Object)other.getPort())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ConnectionImpl otherImpl = (ConnectionImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Connection>>, Augmentation<Connection>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Connection [");
            boolean first = true;
            if (this._ipAddress != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ipAddress=");
                builder.append(this._ipAddress);
            }
            if (this._port != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_port=");
                builder.append(this._port);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

