/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.packetcable.rev150327;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosGates;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.Qos;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.Apps;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class QosBuilder
implements Builder<Qos> {
    private List<Apps> _apps;
    Map<Class<? extends Augmentation<Qos>>, Augmentation<Qos>> augmentation = Collections.emptyMap();

    public QosBuilder() {
    }

    public QosBuilder(PcmmQosGates arg) {
        this._apps = arg.getApps();
    }

    public QosBuilder(Qos base) {
        AugmentationHolder casted;
        this._apps = base.getApps();
        if (base instanceof QosImpl) {
            QosImpl impl = (QosImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Qos>>, Augmentation<Qos>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Qos>>, Augmentation<Qos>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof PcmmQosGates) {
            this._apps = ((PcmmQosGates)arg).getApps();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosGates] \nbut was: " + arg);
        }
    }

    public List<Apps> getApps() {
        return this._apps;
    }

    public <E extends Augmentation<Qos>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public QosBuilder setApps(List<Apps> value) {
        this._apps = value;
        return this;
    }

    public QosBuilder addAugmentation(Class<? extends Augmentation<Qos>> augmentationType, Augmentation<Qos> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Qos>>, Augmentation<Qos>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public QosBuilder removeAugmentation(Class<? extends Augmentation<Qos>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Qos build() {
        return new QosImpl(this);
    }

    private static final class QosImpl
    implements Qos {
        private final List<Apps> _apps;
        private Map<Class<? extends Augmentation<Qos>>, Augmentation<Qos>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Qos> getImplementedInterface() {
            return Qos.class;
        }

        private QosImpl(QosBuilder base) {
            this._apps = base.getApps();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Qos>>, Augmentation<Qos>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Qos>>, Augmentation<Qos>>(base.augmentation);
                }
            }
        }

        @Override
        public List<Apps> getApps() {
            return this._apps;
        }

        public <E extends Augmentation<Qos>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._apps == null ? 0 : this._apps.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Qos.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Qos other = (Qos)obj;
            if (this._apps == null ? other.getApps() != null : !this._apps.equals(other.getApps())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                QosImpl otherImpl = (QosImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Qos>>, Augmentation<Qos>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Qos [");
            boolean first = true;
            if (this._apps != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_apps=");
                builder.append(this._apps);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

