package org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.CcapAttributes;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.Ccap;


/**
 * CCAP devices are known by their network name which is any string.Each CCAP 
 * device has a network address:port, a list of subscriber IP subnets,and a list of
 * available Service Class Names.
 *
 * &lt;p&gt;This class represents the following YANG schema fragment defined in module &lt;b&gt;packetcable&lt;/b&gt;
 * &lt;br&gt;(Source path: &lt;i&gt;META-INF/yang/packetcable.yang&lt;/i&gt;):
 * &lt;pre&gt;
 * list ccaps {
 *     key "ccapId"
 *     leaf ccapId {
 *         type string;
 *     }
 *     container connection {
 *         leaf ipAddress {
 *             type ip-address;
 *         }
 *         leaf port {
 *             type port-number;
 *         }
 *     }
 *     container amId {
 *         leaf am-tag {
 *             type uint16;
 *         }
 *         leaf am-type {
 *             type uint16;
 *         }
 *     }
 *     leaf-list subscriber-subnets {
 *         type ip-prefix;
 *     }
 *     leaf-list upstream-scns {
 *         type service-class-name;
 *     }
 *     leaf-list downstream-scns {
 *         type service-class-name;
 *     }
 *     uses ccap-attributes;
 * }
 * &lt;/pre&gt;
 * The schema path to identify an instance is
 * &lt;i&gt;packetcable/ccap/ccaps&lt;/i&gt;
 *
 * &lt;p&gt;To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.CcapsBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.CcapsBuilder
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.CcapsKey
 *
 */
public interface Ccaps
    extends
    ChildOf<Ccap>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.Ccaps>,
    CcapAttributes,
    Identifiable<CcapsKey>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.cachedReference(org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable","2015-03-27","ccaps"));

    /**
     * CCAP Identity
     *
     */
    java.lang.String getCcapId();
    
    /**
     * Returns Primary Key of Yang List Type
     *
     */
    CcapsKey getKey();

}

