package org.opendaylight.yang.gen.v1.urn.packetcable.rev150327;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.PortNumber;


/**
 * &lt;p&gt;This class represents the following YANG schema fragment defined in module &lt;b&gt;packetcable&lt;/b&gt;
 * &lt;br&gt;(Source path: &lt;i&gt;META-INF/yang/packetcable.yang&lt;/i&gt;):
 * &lt;pre&gt;
 * grouping tp-port-match-ranges {
 *     leaf srcPort-start {
 *         type port-number;
 *     }
 *     leaf srcPort-end {
 *         type port-number;
 *     }
 *     leaf dstPort-start {
 *         type port-number;
 *     }
 *     leaf dstPort-end {
 *         type port-number;
 *     }
 * }
 * &lt;/pre&gt;
 * The schema path to identify an instance is
 * &lt;i&gt;packetcable/tp-port-match-ranges&lt;/i&gt;
 *
 */
public interface TpPortMatchRanges
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.cachedReference(org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable","2015-03-27","tp-port-match-ranges"));

    /**
     * TCP/UDP source port range start.
     *
     */
    PortNumber getSrcPortStart();
    
    /**
     * TCP/UDP source port range end.
     *
     */
    PortNumber getSrcPortEnd();
    
    /**
     * TCP/UDP destination port range start.
     *
     */
    PortNumber getDstPortStart();
    
    /**
     * TCP/UDP destination port range end.
     *
     */
    PortNumber getDstPortEnd();

}

