package org.opendaylight.yang.gen.v1.urn.packetcable.rev150327;
import java.util.Collections;
import java.util.Map;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.Ccaps;
import java.util.List;
import org.opendaylight.yangtools.yang.binding.Augmentation;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.Ccap} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.Ccap
 *
 */
public class CcapBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.Ccap> {

    private List<Ccaps> _ccaps;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.Ccap>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.Ccap>> augmentation = Collections.emptyMap();

    public CcapBuilder() {
    }

    public CcapBuilder(Ccap base) {
        this._ccaps = base.getCcaps();
        if (base instanceof CcapImpl) {
            CcapImpl impl = (CcapImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.Ccap> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.Ccap>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public List<Ccaps> getCcaps() {
        return _ccaps;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.Ccap>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

    public CcapBuilder setCcaps(List<Ccaps> value) {
        this._ccaps = value;
        return this;
    }
    
    public CcapBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.Ccap>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.Ccap> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public CcapBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.Ccap>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Ccap build() {
        return new CcapImpl(this);
    }

    private static final class CcapImpl implements Ccap {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.Ccap> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.Ccap.class;
        }

        private final List<Ccaps> _ccaps;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.Ccap>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.Ccap>> augmentation = Collections.emptyMap();

        private CcapImpl(CcapBuilder base) {
            this._ccaps = base.getCcaps();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.Ccap>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.Ccap>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.Ccap>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.Ccap>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public List<Ccaps> getCcaps() {
            return _ccaps;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.Ccap>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_ccaps == null) ? 0 : _ccaps.hashCode());
            result = prime * result + ((augmentation == null) ? 0 : augmentation.hashCode());
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.Ccap.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.Ccap other = (org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.Ccap)obj;
            if (_ccaps == null) {
                if (other.getCcaps() != null) {
                    return false;
                }
            } else if(!_ccaps.equals(other.getCcaps())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                CcapImpl otherImpl = (CcapImpl) obj;
                if (augmentation == null) {
                    if (otherImpl.augmentation != null) {
                        return false;
                    }
                } else if(!augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.Ccap>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.Ccap>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("Ccap [");
            boolean first = true;
        
            if (_ccaps != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ccaps=");
                builder.append(_ccaps);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
