/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosClassifier;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosExtClassifier;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosGateAttributes;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosGateSpec;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosIpv6Classifier;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosTrafficProfile;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.classifier.Classifier;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier.ExtClassifier;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gate.spec.GateSpec;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.Gates;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.GatesKey;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier.Ipv6Classifier;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.traffic.profile.TrafficProfile;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class GatesBuilder
implements Builder<Gates> {
    private Classifier _classifier;
    private ExtClassifier _extClassifier;
    private String _gateId;
    private GateSpec _gateSpec;
    private Ipv6Classifier _ipv6Classifier;
    private GatesKey _key;
    private String _response;
    private TrafficProfile _trafficProfile;
    Map<Class<? extends Augmentation<Gates>>, Augmentation<Gates>> augmentation = Collections.emptyMap();

    public GatesBuilder() {
    }

    public GatesBuilder(PcmmQosGateAttributes arg) {
        this._response = arg.getResponse();
        this._gateSpec = arg.getGateSpec();
        this._classifier = arg.getClassifier();
        this._ipv6Classifier = arg.getIpv6Classifier();
        this._trafficProfile = arg.getTrafficProfile();
        this._extClassifier = arg.getExtClassifier();
    }

    public GatesBuilder(PcmmQosGateSpec arg) {
        this._gateSpec = arg.getGateSpec();
    }

    public GatesBuilder(PcmmQosClassifier arg) {
        this._classifier = arg.getClassifier();
    }

    public GatesBuilder(PcmmQosIpv6Classifier arg) {
        this._ipv6Classifier = arg.getIpv6Classifier();
    }

    public GatesBuilder(PcmmQosTrafficProfile arg) {
        this._trafficProfile = arg.getTrafficProfile();
    }

    public GatesBuilder(PcmmQosExtClassifier arg) {
        this._extClassifier = arg.getExtClassifier();
    }

    public GatesBuilder(Gates base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new GatesKey(base.getGateId());
            this._gateId = base.getGateId();
        } else {
            this._key = base.getKey();
            this._gateId = this._key.getGateId();
        }
        this._classifier = base.getClassifier();
        this._extClassifier = base.getExtClassifier();
        this._gateSpec = base.getGateSpec();
        this._ipv6Classifier = base.getIpv6Classifier();
        this._response = base.getResponse();
        this._trafficProfile = base.getTrafficProfile();
        if (base instanceof GatesImpl) {
            GatesImpl impl = (GatesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Gates>>, Augmentation<Gates>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Gates>>, Augmentation<Gates>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof PcmmQosGateAttributes) {
            this._response = ((PcmmQosGateAttributes)arg).getResponse();
            isValidArg = true;
        }
        if (arg instanceof PcmmQosGateSpec) {
            this._gateSpec = ((PcmmQosGateSpec)arg).getGateSpec();
            isValidArg = true;
        }
        if (arg instanceof PcmmQosIpv6Classifier) {
            this._ipv6Classifier = ((PcmmQosIpv6Classifier)arg).getIpv6Classifier();
            isValidArg = true;
        }
        if (arg instanceof PcmmQosTrafficProfile) {
            this._trafficProfile = ((PcmmQosTrafficProfile)arg).getTrafficProfile();
            isValidArg = true;
        }
        if (arg instanceof PcmmQosClassifier) {
            this._classifier = ((PcmmQosClassifier)arg).getClassifier();
            isValidArg = true;
        }
        if (arg instanceof PcmmQosExtClassifier) {
            this._extClassifier = ((PcmmQosExtClassifier)arg).getExtClassifier();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosGateAttributes, org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosGateSpec, org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosIpv6Classifier, org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosTrafficProfile, org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosClassifier, org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosExtClassifier] \nbut was: " + arg);
        }
    }

    public Classifier getClassifier() {
        return this._classifier;
    }

    public ExtClassifier getExtClassifier() {
        return this._extClassifier;
    }

    public String getGateId() {
        return this._gateId;
    }

    public GateSpec getGateSpec() {
        return this._gateSpec;
    }

    public Ipv6Classifier getIpv6Classifier() {
        return this._ipv6Classifier;
    }

    public GatesKey getKey() {
        return this._key;
    }

    public String getResponse() {
        return this._response;
    }

    public TrafficProfile getTrafficProfile() {
        return this._trafficProfile;
    }

    public <E extends Augmentation<Gates>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public GatesBuilder setClassifier(Classifier value) {
        this._classifier = value;
        return this;
    }

    public GatesBuilder setExtClassifier(ExtClassifier value) {
        this._extClassifier = value;
        return this;
    }

    public GatesBuilder setGateId(String value) {
        this._gateId = value;
        return this;
    }

    public GatesBuilder setGateSpec(GateSpec value) {
        this._gateSpec = value;
        return this;
    }

    public GatesBuilder setIpv6Classifier(Ipv6Classifier value) {
        this._ipv6Classifier = value;
        return this;
    }

    public GatesBuilder setKey(GatesKey value) {
        this._key = value;
        return this;
    }

    public GatesBuilder setResponse(String value) {
        this._response = value;
        return this;
    }

    public GatesBuilder setTrafficProfile(TrafficProfile value) {
        this._trafficProfile = value;
        return this;
    }

    public GatesBuilder addAugmentation(Class<? extends Augmentation<Gates>> augmentationType, Augmentation<Gates> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Gates>>, Augmentation<Gates>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public GatesBuilder removeAugmentation(Class<? extends Augmentation<Gates>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Gates build() {
        return new GatesImpl(this);
    }

    private static final class GatesImpl
    implements Gates {
        private final Classifier _classifier;
        private final ExtClassifier _extClassifier;
        private final String _gateId;
        private final GateSpec _gateSpec;
        private final Ipv6Classifier _ipv6Classifier;
        private final GatesKey _key;
        private final String _response;
        private final TrafficProfile _trafficProfile;
        private Map<Class<? extends Augmentation<Gates>>, Augmentation<Gates>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Gates> getImplementedInterface() {
            return Gates.class;
        }

        private GatesImpl(GatesBuilder base) {
            if (base.getKey() == null) {
                this._key = new GatesKey(base.getGateId());
                this._gateId = base.getGateId();
            } else {
                this._key = base.getKey();
                this._gateId = this._key.getGateId();
            }
            this._classifier = base.getClassifier();
            this._extClassifier = base.getExtClassifier();
            this._gateSpec = base.getGateSpec();
            this._ipv6Classifier = base.getIpv6Classifier();
            this._response = base.getResponse();
            this._trafficProfile = base.getTrafficProfile();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Gates>>, Augmentation<Gates>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Gates>>, Augmentation<Gates>>(base.augmentation);
                }
            }
        }

        @Override
        public Classifier getClassifier() {
            return this._classifier;
        }

        @Override
        public ExtClassifier getExtClassifier() {
            return this._extClassifier;
        }

        @Override
        public String getGateId() {
            return this._gateId;
        }

        @Override
        public GateSpec getGateSpec() {
            return this._gateSpec;
        }

        @Override
        public Ipv6Classifier getIpv6Classifier() {
            return this._ipv6Classifier;
        }

        @Override
        public GatesKey getKey() {
            return this._key;
        }

        @Override
        public String getResponse() {
            return this._response;
        }

        @Override
        public TrafficProfile getTrafficProfile() {
            return this._trafficProfile;
        }

        public <E extends Augmentation<Gates>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._classifier == null ? 0 : this._classifier.hashCode());
            result = 31 * result + (this._extClassifier == null ? 0 : this._extClassifier.hashCode());
            result = 31 * result + (this._gateId == null ? 0 : this._gateId.hashCode());
            result = 31 * result + (this._gateSpec == null ? 0 : this._gateSpec.hashCode());
            result = 31 * result + (this._ipv6Classifier == null ? 0 : this._ipv6Classifier.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this._response == null ? 0 : this._response.hashCode());
            result = 31 * result + (this._trafficProfile == null ? 0 : this._trafficProfile.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Gates.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Gates other = (Gates)obj;
            if (this._classifier == null ? other.getClassifier() != null : !this._classifier.equals(other.getClassifier())) {
                return false;
            }
            if (this._extClassifier == null ? other.getExtClassifier() != null : !this._extClassifier.equals(other.getExtClassifier())) {
                return false;
            }
            if (this._gateId == null ? other.getGateId() != null : !this._gateId.equals(other.getGateId())) {
                return false;
            }
            if (this._gateSpec == null ? other.getGateSpec() != null : !this._gateSpec.equals(other.getGateSpec())) {
                return false;
            }
            if (this._ipv6Classifier == null ? other.getIpv6Classifier() != null : !this._ipv6Classifier.equals(other.getIpv6Classifier())) {
                return false;
            }
            if (this._key == null ? other.getKey() != null : !this._key.equals(other.getKey())) {
                return false;
            }
            if (this._response == null ? other.getResponse() != null : !this._response.equals(other.getResponse())) {
                return false;
            }
            if (this._trafficProfile == null ? other.getTrafficProfile() != null : !this._trafficProfile.equals(other.getTrafficProfile())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                GatesImpl otherImpl = (GatesImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Gates>>, Augmentation<Gates>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Gates [");
            boolean first = true;
            if (this._classifier != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_classifier=");
                builder.append(this._classifier);
            }
            if (this._extClassifier != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_extClassifier=");
                builder.append(this._extClassifier);
            }
            if (this._gateId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_gateId=");
                builder.append(this._gateId);
            }
            if (this._gateSpec != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_gateSpec=");
                builder.append(this._gateSpec);
            }
            if (this._ipv6Classifier != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ipv6Classifier=");
                builder.append(this._ipv6Classifier);
            }
            if (this._key != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_key=");
                builder.append(this._key);
            }
            if (this._response != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_response=");
                builder.append(this._response);
            }
            if (this._trafficProfile != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_trafficProfile=");
                builder.append(this._trafficProfile);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

