/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gate.spec;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ServiceFlowDirection;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TosByte;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gate.spec.GateSpec;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class GateSpecBuilder
implements Builder<GateSpec> {
    private ServiceFlowDirection _direction;
    private TosByte _dscpTosMask;
    private TosByte _dscpTosOverwrite;
    Map<Class<? extends Augmentation<GateSpec>>, Augmentation<GateSpec>> augmentation = Collections.emptyMap();

    public GateSpecBuilder() {
    }

    public GateSpecBuilder(GateSpec base) {
        AugmentationHolder casted;
        this._direction = base.getDirection();
        this._dscpTosMask = base.getDscpTosMask();
        this._dscpTosOverwrite = base.getDscpTosOverwrite();
        if (base instanceof GateSpecImpl) {
            GateSpecImpl impl = (GateSpecImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<GateSpec>>, Augmentation<GateSpec>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GateSpec>>, Augmentation<GateSpec>>(casted.augmentations());
        }
    }

    public ServiceFlowDirection getDirection() {
        return this._direction;
    }

    public TosByte getDscpTosMask() {
        return this._dscpTosMask;
    }

    public TosByte getDscpTosOverwrite() {
        return this._dscpTosOverwrite;
    }

    public <E extends Augmentation<GateSpec>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public GateSpecBuilder setDirection(ServiceFlowDirection value) {
        this._direction = value;
        return this;
    }

    private static void checkDscpTosMaskRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public GateSpecBuilder setDscpTosMask(TosByte value) {
        if (value != null) {
            GateSpecBuilder.checkDscpTosMaskRange(value.getValue());
        }
        this._dscpTosMask = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _dscpTosMask_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
        return ret;
    }

    private static void checkDscpTosOverwriteRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public GateSpecBuilder setDscpTosOverwrite(TosByte value) {
        if (value != null) {
            GateSpecBuilder.checkDscpTosOverwriteRange(value.getValue());
        }
        this._dscpTosOverwrite = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _dscpTosOverwrite_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
        return ret;
    }

    public GateSpecBuilder addAugmentation(Class<? extends Augmentation<GateSpec>> augmentationType, Augmentation<GateSpec> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GateSpec>>, Augmentation<GateSpec>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public GateSpecBuilder removeAugmentation(Class<? extends Augmentation<GateSpec>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public GateSpec build() {
        return new GateSpecImpl(this);
    }

    private static final class GateSpecImpl
    implements GateSpec {
        private final ServiceFlowDirection _direction;
        private final TosByte _dscpTosMask;
        private final TosByte _dscpTosOverwrite;
        private Map<Class<? extends Augmentation<GateSpec>>, Augmentation<GateSpec>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<GateSpec> getImplementedInterface() {
            return GateSpec.class;
        }

        private GateSpecImpl(GateSpecBuilder base) {
            this._direction = base.getDirection();
            this._dscpTosMask = base.getDscpTosMask();
            this._dscpTosOverwrite = base.getDscpTosOverwrite();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<GateSpec>>, Augmentation<GateSpec>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<GateSpec>>, Augmentation<GateSpec>>(base.augmentation);
                }
            }
        }

        @Override
        public ServiceFlowDirection getDirection() {
            return this._direction;
        }

        @Override
        public TosByte getDscpTosMask() {
            return this._dscpTosMask;
        }

        @Override
        public TosByte getDscpTosOverwrite() {
            return this._dscpTosOverwrite;
        }

        public <E extends Augmentation<GateSpec>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._direction == null ? 0 : this._direction.hashCode());
            result = 31 * result + (this._dscpTosMask == null ? 0 : this._dscpTosMask.hashCode());
            result = 31 * result + (this._dscpTosOverwrite == null ? 0 : this._dscpTosOverwrite.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!GateSpec.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            GateSpec other = (GateSpec)obj;
            if (this._direction == null ? other.getDirection() != null : !this._direction.equals((Object)other.getDirection())) {
                return false;
            }
            if (this._dscpTosMask == null ? other.getDscpTosMask() != null : !this._dscpTosMask.equals(other.getDscpTosMask())) {
                return false;
            }
            if (this._dscpTosOverwrite == null ? other.getDscpTosOverwrite() != null : !this._dscpTosOverwrite.equals(other.getDscpTosOverwrite())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                GateSpecImpl otherImpl = (GateSpecImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<GateSpec>>, Augmentation<GateSpec>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("GateSpec [");
            boolean first = true;
            if (this._direction != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_direction=");
                builder.append((Object)this._direction);
            }
            if (this._dscpTosMask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dscpTosMask=");
                builder.append(this._dscpTosMask);
            }
            if (this._dscpTosOverwrite != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dscpTosOverwrite=");
                builder.append(this._dscpTosOverwrite);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

