/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.AmId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class AmIdBuilder
implements Builder<AmId> {
    private Integer _amTag;
    private Integer _amType;
    Map<Class<? extends Augmentation<AmId>>, Augmentation<AmId>> augmentation = Collections.emptyMap();

    public AmIdBuilder() {
    }

    public AmIdBuilder(AmId base) {
        AugmentationHolder casted;
        this._amTag = base.getAmTag();
        this._amType = base.getAmType();
        if (base instanceof AmIdImpl) {
            AmIdImpl impl = (AmIdImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<AmId>>, Augmentation<AmId>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AmId>>, Augmentation<AmId>>(casted.augmentations());
        }
    }

    public Integer getAmTag() {
        return this._amTag;
    }

    public Integer getAmType() {
        return this._amType;
    }

    public <E extends Augmentation<AmId>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkAmTagRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public AmIdBuilder setAmTag(Integer value) {
        if (value != null) {
            AmIdBuilder.checkAmTagRange(value);
        }
        this._amTag = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _amTag_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }

    private static void checkAmTypeRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public AmIdBuilder setAmType(Integer value) {
        if (value != null) {
            AmIdBuilder.checkAmTypeRange(value);
        }
        this._amType = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _amType_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }

    public AmIdBuilder addAugmentation(Class<? extends Augmentation<AmId>> augmentationType, Augmentation<AmId> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AmId>>, Augmentation<AmId>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public AmIdBuilder removeAugmentation(Class<? extends Augmentation<AmId>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public AmId build() {
        return new AmIdImpl(this);
    }

    private static final class AmIdImpl
    implements AmId {
        private final Integer _amTag;
        private final Integer _amType;
        private Map<Class<? extends Augmentation<AmId>>, Augmentation<AmId>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<AmId> getImplementedInterface() {
            return AmId.class;
        }

        private AmIdImpl(AmIdBuilder base) {
            this._amTag = base.getAmTag();
            this._amType = base.getAmType();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<AmId>>, Augmentation<AmId>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<AmId>>, Augmentation<AmId>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getAmTag() {
            return this._amTag;
        }

        @Override
        public Integer getAmType() {
            return this._amType;
        }

        public <E extends Augmentation<AmId>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._amTag == null ? 0 : this._amTag.hashCode());
            result = 31 * result + (this._amType == null ? 0 : this._amType.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!AmId.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            AmId other = (AmId)obj;
            if (this._amTag == null ? other.getAmTag() != null : !this._amTag.equals(other.getAmTag())) {
                return false;
            }
            if (this._amType == null ? other.getAmType() != null : !this._amType.equals(other.getAmType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                AmIdImpl otherImpl = (AmIdImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<AmId>>, Augmentation<AmId>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("AmId [");
            boolean first = true;
            if (this._amTag != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_amTag=");
                builder.append(this._amTag);
            }
            if (this._amType != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_amType=");
                builder.append(this._amType);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

