/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.IpPrefix;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.CcapAttributes;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ServiceClassName;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.Ccaps;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.CcapsKey;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.AmId;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.Connection;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class CcapsBuilder
implements Builder<Ccaps> {
    private AmId _amId;
    private String _ccapId;
    private Connection _connection;
    private List<ServiceClassName> _downstreamScns;
    private CcapsKey _key;
    private String _response;
    private List<IpPrefix> _subscriberSubnets;
    private List<ServiceClassName> _upstreamScns;
    Map<Class<? extends Augmentation<Ccaps>>, Augmentation<Ccaps>> augmentation = Collections.emptyMap();

    public CcapsBuilder() {
    }

    public CcapsBuilder(CcapAttributes arg) {
        this._connection = arg.getConnection();
        this._amId = arg.getAmId();
        this._subscriberSubnets = arg.getSubscriberSubnets();
        this._upstreamScns = arg.getUpstreamScns();
        this._downstreamScns = arg.getDownstreamScns();
        this._response = arg.getResponse();
    }

    public CcapsBuilder(Ccaps base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new CcapsKey(base.getCcapId());
            this._ccapId = base.getCcapId();
        } else {
            this._key = base.getKey();
            this._ccapId = this._key.getCcapId();
        }
        this._amId = base.getAmId();
        this._connection = base.getConnection();
        this._downstreamScns = base.getDownstreamScns();
        this._response = base.getResponse();
        this._subscriberSubnets = base.getSubscriberSubnets();
        this._upstreamScns = base.getUpstreamScns();
        if (base instanceof CcapsImpl) {
            CcapsImpl impl = (CcapsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Ccaps>>, Augmentation<Ccaps>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ccaps>>, Augmentation<Ccaps>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof CcapAttributes) {
            this._connection = ((CcapAttributes)arg).getConnection();
            this._amId = ((CcapAttributes)arg).getAmId();
            this._subscriberSubnets = ((CcapAttributes)arg).getSubscriberSubnets();
            this._upstreamScns = ((CcapAttributes)arg).getUpstreamScns();
            this._downstreamScns = ((CcapAttributes)arg).getDownstreamScns();
            this._response = ((CcapAttributes)arg).getResponse();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.CcapAttributes] \nbut was: " + arg);
        }
    }

    public AmId getAmId() {
        return this._amId;
    }

    public String getCcapId() {
        return this._ccapId;
    }

    public Connection getConnection() {
        return this._connection;
    }

    public List<ServiceClassName> getDownstreamScns() {
        return this._downstreamScns;
    }

    public CcapsKey getKey() {
        return this._key;
    }

    public String getResponse() {
        return this._response;
    }

    public List<IpPrefix> getSubscriberSubnets() {
        return this._subscriberSubnets;
    }

    public List<ServiceClassName> getUpstreamScns() {
        return this._upstreamScns;
    }

    public <E extends Augmentation<Ccaps>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public CcapsBuilder setAmId(AmId value) {
        this._amId = value;
        return this;
    }

    public CcapsBuilder setCcapId(String value) {
        this._ccapId = value;
        return this;
    }

    public CcapsBuilder setConnection(Connection value) {
        this._connection = value;
        return this;
    }

    public CcapsBuilder setDownstreamScns(List<ServiceClassName> value) {
        this._downstreamScns = value;
        return this;
    }

    public CcapsBuilder setKey(CcapsKey value) {
        this._key = value;
        return this;
    }

    public CcapsBuilder setResponse(String value) {
        this._response = value;
        return this;
    }

    public CcapsBuilder setSubscriberSubnets(List<IpPrefix> value) {
        this._subscriberSubnets = value;
        return this;
    }

    public CcapsBuilder setUpstreamScns(List<ServiceClassName> value) {
        this._upstreamScns = value;
        return this;
    }

    public CcapsBuilder addAugmentation(Class<? extends Augmentation<Ccaps>> augmentationType, Augmentation<Ccaps> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ccaps>>, Augmentation<Ccaps>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public CcapsBuilder removeAugmentation(Class<? extends Augmentation<Ccaps>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Ccaps build() {
        return new CcapsImpl(this);
    }

    private static final class CcapsImpl
    implements Ccaps {
        private final AmId _amId;
        private final String _ccapId;
        private final Connection _connection;
        private final List<ServiceClassName> _downstreamScns;
        private final CcapsKey _key;
        private final String _response;
        private final List<IpPrefix> _subscriberSubnets;
        private final List<ServiceClassName> _upstreamScns;
        private Map<Class<? extends Augmentation<Ccaps>>, Augmentation<Ccaps>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Ccaps> getImplementedInterface() {
            return Ccaps.class;
        }

        private CcapsImpl(CcapsBuilder base) {
            if (base.getKey() == null) {
                this._key = new CcapsKey(base.getCcapId());
                this._ccapId = base.getCcapId();
            } else {
                this._key = base.getKey();
                this._ccapId = this._key.getCcapId();
            }
            this._amId = base.getAmId();
            this._connection = base.getConnection();
            this._downstreamScns = base.getDownstreamScns();
            this._response = base.getResponse();
            this._subscriberSubnets = base.getSubscriberSubnets();
            this._upstreamScns = base.getUpstreamScns();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Ccaps>>, Augmentation<Ccaps>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Ccaps>>, Augmentation<Ccaps>>(base.augmentation);
                }
            }
        }

        @Override
        public AmId getAmId() {
            return this._amId;
        }

        @Override
        public String getCcapId() {
            return this._ccapId;
        }

        @Override
        public Connection getConnection() {
            return this._connection;
        }

        @Override
        public List<ServiceClassName> getDownstreamScns() {
            return this._downstreamScns;
        }

        @Override
        public CcapsKey getKey() {
            return this._key;
        }

        @Override
        public String getResponse() {
            return this._response;
        }

        @Override
        public List<IpPrefix> getSubscriberSubnets() {
            return this._subscriberSubnets;
        }

        @Override
        public List<ServiceClassName> getUpstreamScns() {
            return this._upstreamScns;
        }

        public <E extends Augmentation<Ccaps>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._amId == null ? 0 : this._amId.hashCode());
            result = 31 * result + (this._ccapId == null ? 0 : this._ccapId.hashCode());
            result = 31 * result + (this._connection == null ? 0 : this._connection.hashCode());
            result = 31 * result + (this._downstreamScns == null ? 0 : this._downstreamScns.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this._response == null ? 0 : this._response.hashCode());
            result = 31 * result + (this._subscriberSubnets == null ? 0 : this._subscriberSubnets.hashCode());
            result = 31 * result + (this._upstreamScns == null ? 0 : this._upstreamScns.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Ccaps.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Ccaps other = (Ccaps)obj;
            if (this._amId == null ? other.getAmId() != null : !this._amId.equals(other.getAmId())) {
                return false;
            }
            if (this._ccapId == null ? other.getCcapId() != null : !this._ccapId.equals(other.getCcapId())) {
                return false;
            }
            if (this._connection == null ? other.getConnection() != null : !this._connection.equals(other.getConnection())) {
                return false;
            }
            if (this._downstreamScns == null ? other.getDownstreamScns() != null : !this._downstreamScns.equals(other.getDownstreamScns())) {
                return false;
            }
            if (this._key == null ? other.getKey() != null : !this._key.equals(other.getKey())) {
                return false;
            }
            if (this._response == null ? other.getResponse() != null : !this._response.equals(other.getResponse())) {
                return false;
            }
            if (this._subscriberSubnets == null ? other.getSubscriberSubnets() != null : !this._subscriberSubnets.equals(other.getSubscriberSubnets())) {
                return false;
            }
            if (this._upstreamScns == null ? other.getUpstreamScns() != null : !this._upstreamScns.equals(other.getUpstreamScns())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                CcapsImpl otherImpl = (CcapsImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Ccaps>>, Augmentation<Ccaps>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Ccaps [");
            boolean first = true;
            if (this._amId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_amId=");
                builder.append(this._amId);
            }
            if (this._ccapId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ccapId=");
                builder.append(this._ccapId);
            }
            if (this._connection != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_connection=");
                builder.append(this._connection);
            }
            if (this._downstreamScns != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_downstreamScns=");
                builder.append(this._downstreamScns);
            }
            if (this._key != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_key=");
                builder.append(this._key);
            }
            if (this._response != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_response=");
                builder.append(this._response);
            }
            if (this._subscriberSubnets != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_subscriberSubnets=");
                builder.append(this._subscriberSubnets);
            }
            if (this._upstreamScns != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_upstreamScns=");
                builder.append(this._upstreamScns);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

