/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.packetcable.rev150327;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.Ccap;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.Ccaps;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class CcapBuilder
implements Builder<Ccap> {
    private List<Ccaps> _ccaps;
    Map<Class<? extends Augmentation<Ccap>>, Augmentation<Ccap>> augmentation = Collections.emptyMap();

    public CcapBuilder() {
    }

    public CcapBuilder(Ccap base) {
        AugmentationHolder casted;
        this._ccaps = base.getCcaps();
        if (base instanceof CcapImpl) {
            CcapImpl impl = (CcapImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Ccap>>, Augmentation<Ccap>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ccap>>, Augmentation<Ccap>>(casted.augmentations());
        }
    }

    public List<Ccaps> getCcaps() {
        return this._ccaps;
    }

    public <E extends Augmentation<Ccap>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public CcapBuilder setCcaps(List<Ccaps> value) {
        this._ccaps = value;
        return this;
    }

    public CcapBuilder addAugmentation(Class<? extends Augmentation<Ccap>> augmentationType, Augmentation<Ccap> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ccap>>, Augmentation<Ccap>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public CcapBuilder removeAugmentation(Class<? extends Augmentation<Ccap>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Ccap build() {
        return new CcapImpl(this);
    }

    private static final class CcapImpl
    implements Ccap {
        private final List<Ccaps> _ccaps;
        private Map<Class<? extends Augmentation<Ccap>>, Augmentation<Ccap>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Ccap> getImplementedInterface() {
            return Ccap.class;
        }

        private CcapImpl(CcapBuilder base) {
            this._ccaps = base.getCcaps();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Ccap>>, Augmentation<Ccap>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Ccap>>, Augmentation<Ccap>>(base.augmentation);
                }
            }
        }

        @Override
        public List<Ccaps> getCcaps() {
            return this._ccaps;
        }

        public <E extends Augmentation<Ccap>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._ccaps == null ? 0 : this._ccaps.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Ccap.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Ccap other = (Ccap)obj;
            if (this._ccaps == null ? other.getCcaps() != null : !this._ccaps.equals(other.getCcaps())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                CcapImpl otherImpl = (CcapImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Ccap>>, Augmentation<Ccap>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Ccap [");
            boolean first = true;
            if (this._ccaps != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ccaps=");
                builder.append(this._ccaps);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

