/*
 * Decompiled with CFR 0.152.
 */
package org.pcmm.rcd.impl;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.pcmm.gates.IGateSpec;
import org.pcmm.rcd.ICMTS;
import org.pcmm.rcd.IPCMMServer;
import org.pcmm.rcd.impl.AbstractPCMMServer;
import org.pcmm.rcd.impl.CmtsPcmmClientHandler;

public class CMTS
extends AbstractPCMMServer
implements ICMTS {
    private final Map<String, IPCMMServer.IPCMMClientHandler> handlerMap;
    private final Map<IGateSpec.Direction, Set<String>> gateConfig;
    private final Map<String, Boolean> cmStatus;

    public CMTS(Map<IGateSpec.Direction, Set<String>> gateConfig, Map<String, Boolean> cmStatus) {
        this(0, gateConfig, cmStatus);
    }

    public CMTS(int port, Map<IGateSpec.Direction, Set<String>> gateConfig, Map<String, Boolean> cmStatus) {
        super(port);
        if (gateConfig == null || cmStatus == null) {
            throw new IllegalArgumentException("Config must not be null");
        }
        this.gateConfig = Collections.unmodifiableMap(gateConfig);
        this.cmStatus = Collections.unmodifiableMap(cmStatus);
        this.handlerMap = new ConcurrentHashMap<String, IPCMMServer.IPCMMClientHandler>();
    }

    public void stopServer() {
        for (IPCMMServer.IPCMMClientHandler handler : this.handlerMap.values()) {
            handler.stop();
        }
        super.stopServer();
    }

    protected IPCMMServer.IPCMMClientHandler getPCMMClientHandler(Socket socket) throws IOException {
        String key = socket.getLocalAddress().getHostName() + ':' + socket.getPort();
        if (this.handlerMap.get(key) == null) {
            CmtsPcmmClientHandler handler = new CmtsPcmmClientHandler(socket, this.gateConfig, this.cmStatus);
            handler.connect();
            this.handlerMap.put(key, (IPCMMServer.IPCMMClientHandler)handler);
            return handler;
        }
        return this.handlerMap.get(key);
    }

    public static void main(String[] args) throws IOException {
        CmtsYaml config = CMTS.getConfig(args[0]);
        CMTS cmts = new CMTS(config.port, config.getGates(), config.getCmStatus());
        cmts.startServer();
    }

    private static CmtsYaml getConfig(String uri) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (CmtsYaml)mapper.readValue((InputStream)new FileInputStream(uri), CmtsYaml.class);
    }

    public static class CmStatusYaml {
        @JsonProperty(value="host")
        private String hostIp;
        @JsonProperty(value="status")
        private boolean status;
    }

    public static class GateConfigYaml {
        @JsonProperty(value="type")
        private String gateType;
        @JsonProperty(value="names")
        private Set<String> gateNames;
    }

    public static class CmtsYaml {
        @JsonProperty(value="port")
        private int port;
        @JsonProperty(value="gates")
        private Collection<GateConfigYaml> gateConfigs;
        @JsonProperty(value="cmStatuses")
        private Collection<CmStatusYaml> cmStatuses;

        public Map<IGateSpec.Direction, Set<String>> getGates() {
            HashMap<IGateSpec.Direction, Set<String>> out = new HashMap<IGateSpec.Direction, Set<String>>();
            for (GateConfigYaml gateConfig : this.gateConfigs) {
                Object direction = gateConfig.gateType.equalsIgnoreCase("UPSTREAM") ? IGateSpec.Direction.UPSTREAM : (gateConfig.gateType.equalsIgnoreCase("DOWNSTREAM") ? IGateSpec.Direction.DOWNSTREAM : null);
                if (direction == null) continue;
                out.put((IGateSpec.Direction)direction, gateConfig.gateNames);
            }
            return out;
        }

        public Map<String, Boolean> getCmStatus() {
            HashMap<String, Boolean> out = new HashMap<String, Boolean>();
            for (CmStatusYaml cmStatus : this.cmStatuses) {
                out.put(cmStatus.hostIp, cmStatus.status);
            }
            return out;
        }
    }
}

