/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.config.pcmm_service.impl;

import java.util.Objects;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.RuntimeBeanRegistratorAwareModule;
import org.opendaylight.controller.config.api.annotations.RequireInterface;
import org.opendaylight.controller.config.api.runtime.RootRuntimeBeanRegistrator;
import org.opendaylight.controller.config.spi.AbstractModule;
import org.opendaylight.controller.config.yang.config.pcmm_service.impl.PcmmServiceModuleMXBean;
import org.opendaylight.controller.config.yang.config.pcmm_service.impl.PcmmServiceRuntimeRegistrator;
import org.opendaylight.controller.config.yang.config.pcmm_service.impl.PcmmServiceServiceInterface;
import org.opendaylight.controller.config.yang.md.sal.binding.NotificationProviderServiceServiceInterface;
import org.opendaylight.controller.config.yang.md.sal.binding.RpcProviderRegistryServiceInterface;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.controller.sal.binding.api.RpcProviderRegistry;
import org.opendaylight.yangtools.yang.binding.annotations.ModuleQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ModuleQName(revision="2014-08-10", name="pcmm-service-impl", namespace="urn:opendaylight:params:xml:ns:yang:controller:config:pcmm-service:impl")
public abstract class AbstractPcmmServiceModule
extends AbstractModule<AbstractPcmmServiceModule>
implements PcmmServiceModuleMXBean,
PcmmServiceServiceInterface,
RuntimeBeanRegistratorAwareModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPcmmServiceModule.class);
    public static final JmxAttribute notificationServiceJmxAttribute = new JmxAttribute("NotificationService");
    private ObjectName notificationService;
    public static final JmxAttribute rpcRegistryJmxAttribute = new JmxAttribute("RpcRegistry");
    private ObjectName rpcRegistry;
    private PcmmServiceRuntimeRegistrator rootRuntimeBeanRegistratorWrapper;
    private NotificationProviderService notificationServiceDependency;
    private RpcProviderRegistry rpcRegistryDependency;

    public AbstractPcmmServiceModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public AbstractPcmmServiceModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, AbstractPcmmServiceModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, (AbstractModule)oldModule, oldInstance);
    }

    public PcmmServiceRuntimeRegistrator getRootRuntimeBeanRegistratorWrapper() {
        return this.rootRuntimeBeanRegistratorWrapper;
    }

    public void setRuntimeBeanRegistrator(RootRuntimeBeanRegistrator rootRuntimeRegistrator) {
        this.rootRuntimeBeanRegistratorWrapper = new PcmmServiceRuntimeRegistrator(rootRuntimeRegistrator);
    }

    public void validate() {
        this.dependencyResolver.validateDependency(NotificationProviderServiceServiceInterface.class, this.notificationService, notificationServiceJmxAttribute);
        this.dependencyResolver.validateDependency(RpcProviderRegistryServiceInterface.class, this.rpcRegistry, rpcRegistryJmxAttribute);
        this.customValidation();
    }

    protected void customValidation() {
    }

    protected final NotificationProviderService getNotificationServiceDependency() {
        return this.notificationServiceDependency;
    }

    protected final RpcProviderRegistry getRpcRegistryDependency() {
        return this.rpcRegistryDependency;
    }

    protected final void resolveDependencies() {
        this.notificationServiceDependency = (NotificationProviderService)this.dependencyResolver.resolveInstance(NotificationProviderService.class, this.notificationService, notificationServiceJmxAttribute);
        this.rpcRegistryDependency = (RpcProviderRegistry)this.dependencyResolver.resolveInstance(RpcProviderRegistry.class, this.rpcRegistry, rpcRegistryJmxAttribute);
    }

    public boolean canReuseInstance(AbstractPcmmServiceModule oldModule) {
        return this.isSame(oldModule);
    }

    public AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    public boolean isSame(AbstractPcmmServiceModule other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' is null");
        }
        if (!Objects.deepEquals(this.notificationService, other.notificationService)) {
            return false;
        }
        if (this.notificationService != null && !this.dependencyResolver.canReuseDependency(this.notificationService, notificationServiceJmxAttribute)) {
            return false;
        }
        if (!Objects.deepEquals(this.rpcRegistry, other.rpcRegistry)) {
            return false;
        }
        return this.rpcRegistry == null || this.dependencyResolver.canReuseDependency(this.rpcRegistry, rpcRegistryJmxAttribute);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractPcmmServiceModule that = (AbstractPcmmServiceModule)o;
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    @Override
    public ObjectName getNotificationService() {
        return this.notificationService;
    }

    @Override
    @RequireInterface(value=NotificationProviderServiceServiceInterface.class)
    public void setNotificationService(ObjectName notificationService) {
        this.notificationService = notificationService;
    }

    @Override
    public ObjectName getRpcRegistry() {
        return this.rpcRegistry;
    }

    @Override
    @RequireInterface(value=RpcProviderRegistryServiceInterface.class)
    public void setRpcRegistry(ObjectName rpcRegistry) {
        this.rpcRegistry = rpcRegistry;
    }

    public Logger getLogger() {
        return LOGGER;
    }
}

