/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.org.pcmm.impl;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import org.opendaylight.controller.org.pcmm.api.PcmmService;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.node.cmts.broker.rev140909.CmtsAdded;
import org.opendaylight.yang.gen.v1.urn.opendaylight.node.cmts.broker.rev140909.CmtsRemoved;
import org.opendaylight.yang.gen.v1.urn.opendaylight.node.cmts.broker.rev140909.CmtsUpdated;
import org.pcmm.rcd.IPCMMPolicyServer;
import org.pcmm.rcd.impl.PCMMPolicyServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcmmServiceImpl
implements PcmmService {
    private static final Logger logger = LoggerFactory.getLogger(PcmmServiceImpl.class);
    private Map<IpAddress, IPCMMPolicyServer.IPSCMTSClient> cmtsClients;
    private IPCMMPolicyServer policyServer = new PCMMPolicyServer();

    public PcmmServiceImpl() {
        this.cmtsClients = Maps.newConcurrentMap();
    }

    public void onCmtsAdded(CmtsAdded notification) {
        String ipv4 = notification.getAddress().getIpv4Address().getValue();
        IPCMMPolicyServer.IPSCMTSClient client = this.policyServer.requestCMTSConnection(ipv4);
        if (client.isConnected()) {
            this.cmtsClients.put(notification.getAddress(), client);
        }
    }

    public void onCmtsRemoved(CmtsRemoved notification) {
        if (this.cmtsClients.containsKey(notification.getAddress())) {
            IPCMMPolicyServer.IPSCMTSClient client = this.cmtsClients.remove(notification.getAddress());
            client.disconnect();
        }
    }

    public void onCmtsUpdated(CmtsUpdated notification) {
    }

    @Override
    public Boolean sendGateDelete() {
        boolean ret = true;
        Iterator<IPCMMPolicyServer.IPSCMTSClient> iter = this.cmtsClients.values().iterator();
        while (iter.hasNext()) {
            ret &= this.cmtsClients.get(0).gateDelete();
        }
        return ret;
    }

    @Override
    public Boolean sendGateSynchronize() {
        boolean ret = true;
        Iterator<IPCMMPolicyServer.IPSCMTSClient> iter = this.cmtsClients.values().iterator();
        while (iter.hasNext()) {
            ret &= this.cmtsClients.get(0).gateSynchronize();
        }
        return ret;
    }

    @Override
    public Boolean sendGateInfo() {
        boolean ret = true;
        Iterator<IPCMMPolicyServer.IPSCMTSClient> iter = this.cmtsClients.values().iterator();
        while (iter.hasNext()) {
            ret &= this.cmtsClients.get(0).gateInfo();
        }
        return ret;
    }

    @Override
    public Boolean sendGateSet() {
        boolean ret = true;
        Iterator<IPCMMPolicyServer.IPSCMTSClient> iter = this.cmtsClients.values().iterator();
        while (iter.hasNext()) {
            ret &= this.cmtsClients.get(0).gateSet();
        }
        return ret;
    }
}

