/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.config.pcmm_service.impl;

import javax.management.ObjectName;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.RuntimeBeanRegistratorAwareModule;
import org.opendaylight.controller.config.api.annotations.RequireInterface;
import org.opendaylight.controller.config.api.runtime.RootRuntimeBeanRegistrator;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.yang.config.pcmm_service.impl.PcmmServiceModuleMXBean;
import org.opendaylight.controller.config.yang.config.pcmm_service.impl.PcmmServiceRuntimeRegistrator;
import org.opendaylight.controller.config.yang.config.pcmm_service.impl.PcmmServiceServiceInterface;
import org.opendaylight.controller.config.yang.md.sal.binding.NotificationProviderServiceServiceInterface;
import org.opendaylight.controller.config.yang.md.sal.binding.RpcProviderRegistryServiceInterface;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.controller.sal.binding.api.RpcProviderRegistry;
import org.opendaylight.yangtools.yang.binding.annotations.ModuleQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ModuleQName(revision="2014-08-10", name="pcmm-service-impl", namespace="urn:opendaylight:params:xml:ns:yang:controller:config:pcmm-service:impl")
public abstract class AbstractPcmmServiceModule
implements Module,
PcmmServiceModuleMXBean,
PcmmServiceServiceInterface,
RuntimeBeanRegistratorAwareModule {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPcmmServiceModule.class);
    public static final JmxAttribute notificationServiceJmxAttribute = new JmxAttribute("NotificationService");
    private ObjectName notificationService;
    public static final JmxAttribute rpcRegistryJmxAttribute = new JmxAttribute("RpcRegistry");
    private ObjectName rpcRegistry;
    private final AbstractPcmmServiceModule oldModule;
    private final AutoCloseable oldInstance;
    private AutoCloseable instance;
    protected final DependencyResolver dependencyResolver;
    private final ModuleIdentifier identifier;
    private PcmmServiceRuntimeRegistrator rootRuntimeBeanRegistratorWrapper;
    private NotificationProviderService notificationServiceDependency;
    private RpcProviderRegistry rpcRegistryDependency;

    public ModuleIdentifier getIdentifier() {
        return this.identifier;
    }

    public AbstractPcmmServiceModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        this.identifier = identifier;
        this.dependencyResolver = dependencyResolver;
        this.oldInstance = null;
        this.oldModule = null;
    }

    public AbstractPcmmServiceModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, AbstractPcmmServiceModule oldModule, AutoCloseable oldInstance) {
        this.identifier = identifier;
        this.dependencyResolver = dependencyResolver;
        this.oldModule = oldModule;
        this.oldInstance = oldInstance;
    }

    public PcmmServiceRuntimeRegistrator getRootRuntimeBeanRegistratorWrapper() {
        return this.rootRuntimeBeanRegistratorWrapper;
    }

    public void setRuntimeBeanRegistrator(RootRuntimeBeanRegistrator rootRuntimeRegistrator) {
        this.rootRuntimeBeanRegistratorWrapper = new PcmmServiceRuntimeRegistrator(rootRuntimeRegistrator);
    }

    public void validate() {
        this.dependencyResolver.validateDependency(NotificationProviderServiceServiceInterface.class, this.notificationService, notificationServiceJmxAttribute);
        this.dependencyResolver.validateDependency(RpcProviderRegistryServiceInterface.class, this.rpcRegistry, rpcRegistryJmxAttribute);
        this.customValidation();
    }

    protected void customValidation() {
    }

    protected final NotificationProviderService getNotificationServiceDependency() {
        return this.notificationServiceDependency;
    }

    protected final RpcProviderRegistry getRpcRegistryDependency() {
        return this.rpcRegistryDependency;
    }

    public final AutoCloseable getInstance() {
        if (this.instance == null) {
            this.rpcRegistryDependency = (RpcProviderRegistry)this.dependencyResolver.resolveInstance(RpcProviderRegistry.class, this.rpcRegistry, rpcRegistryJmxAttribute);
            this.notificationServiceDependency = (NotificationProviderService)this.dependencyResolver.resolveInstance(NotificationProviderService.class, this.notificationService, notificationServiceJmxAttribute);
            if (this.oldInstance != null && this.canReuseInstance(this.oldModule)) {
                this.instance = this.reuseInstance(this.oldInstance);
            } else {
                if (this.oldInstance != null) {
                    try {
                        this.oldInstance.close();
                    }
                    catch (Exception e) {
                        logger.error("An error occurred while closing old instance " + this.oldInstance, (Throwable)e);
                    }
                }
                this.instance = this.createInstance();
                if (this.instance == null) {
                    throw new IllegalStateException("Error in createInstance - null is not allowed as return value");
                }
            }
        }
        return this.instance;
    }

    public abstract AutoCloseable createInstance();

    public boolean canReuseInstance(AbstractPcmmServiceModule oldModule) {
        return this.isSame(oldModule);
    }

    public AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    public boolean isSame(AbstractPcmmServiceModule other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' is null");
        }
        if (this.notificationServiceDependency != other.notificationServiceDependency) {
            return false;
        }
        return this.rpcRegistryDependency == other.rpcRegistryDependency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractPcmmServiceModule that = (AbstractPcmmServiceModule)o;
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    @Override
    public ObjectName getNotificationService() {
        return this.notificationService;
    }

    @Override
    @RequireInterface(value=NotificationProviderServiceServiceInterface.class)
    public void setNotificationService(ObjectName notificationService) {
        this.notificationService = notificationService;
    }

    @Override
    public ObjectName getRpcRegistry() {
        return this.rpcRegistry;
    }

    @Override
    @RequireInterface(value=RpcProviderRegistryServiceInterface.class)
    public void setRpcRegistry(ObjectName rpcRegistry) {
        this.rpcRegistry = rpcRegistry;
    }
}

