/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.groupbasedpolicy.ip.sgt.distribution.service.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Future;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.WriteTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.groupbasedpolicy.ip.sgt.distribution.service.impl.SxpCapableNodeListener;
import org.opendaylight.sxp.util.time.TimeConv;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715.IpSgtDistributionService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715.RemoveIpSgtBindingFromPeerInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715.SendIpSgtBindingToPeerInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715.rpc.fields.Binding;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715.rpc.fields.binding.PeerNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.controller.rev141002.AddNodeInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.controller.rev141002.AddNodeInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.controller.rev141002.AddNodeOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.controller.rev141002.SxpControllerService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.database.rev160308.Sgt;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.database.rev160308.master.database.fields.MasterDatabaseBinding;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.database.rev160308.master.database.fields.MasterDatabaseBindingBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.database.rev160308.master.database.fields.MasterDatabaseBindingKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.database.rev160308.peer.sequence.fields.PeerSequenceBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.node.rev160308.SxpNodeIdentity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.node.rev160308.network.topology.topology.node.SxpDomains;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.node.rev160308.network.topology.topology.node.sxp.domains.SxpDomain;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.node.rev160308.network.topology.topology.node.sxp.domains.SxpDomainKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.node.rev160308.sxp.databases.fields.MasterDatabase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.protocol.rev141002.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpSgtDistributionServiceImpl
implements AutoCloseable,
IpSgtDistributionService {
    private static final Logger LOG = LoggerFactory.getLogger(IpSgtDistributionServiceImpl.class);
    public static final String SXP_NODE_DESCRIPTION = "ODL-GBP SXP node";
    public static final String SXP_TOPOLOGY_ID = "sxp";
    private final String SXP_NODE_ID;
    private DataBroker dataBroker;
    private IpAddress sourceIp;
    private SxpCapableNodeListener nodeCollector;

    public IpSgtDistributionServiceImpl(DataBroker dataBroker, SxpControllerService sxpService, IpAddress sourceIp) {
        this.dataBroker = (DataBroker)Preconditions.checkNotNull((Object)dataBroker);
        this.sourceIp = (IpAddress)Preconditions.checkNotNull((Object)sourceIp);
        Preconditions.checkNotNull((Object)sxpService);
        this.SXP_NODE_ID = sourceIp.getIpv4Address() != null ? sourceIp.getIpv4Address().getValue() : sourceIp.getIpv6Address().getValue();
        this.createSxpNode(sxpService);
        this.nodeCollector = new SxpCapableNodeListener(dataBroker, this.SXP_NODE_ID);
    }

    private void createSxpNode(SxpControllerService sxpService) {
        AddNodeInput addNodeInput = new AddNodeInputBuilder().setNodeId(new NodeId(this.SXP_NODE_ID)).setSourceIp(this.sourceIp).setDescription(SXP_NODE_DESCRIPTION).build();
        Future addNodeResult = sxpService.addNode(addNodeInput);
        try {
            if (!((AddNodeOutput)((RpcResult)addNodeResult.get()).getResult()).isResult().booleanValue()) {
                LOG.error("RPC add-node wasn't successfull");
            }
        }
        catch (Exception e) {
            LOG.error("RPC add-node wasn't successfull");
        }
    }

    @Override
    public Future<RpcResult<Void>> sendIpSgtBindingToPeer(SendIpSgtBindingToPeerInput input) {
        Binding binding;
        HashMap<String, Multimap<Sgt, IpPrefix>> bindingsMap = new HashMap<String, Multimap<Sgt, IpPrefix>>();
        boolean success = true;
        Iterator<Binding> iterator = input.getBinding().iterator();
        while (iterator.hasNext() && (success = this.transformChanges(binding = iterator.next(), bindingsMap))) {
        }
        if (!success) {
            return Futures.immediateCheckedFuture((Object)RpcResultBuilder.failed().build());
        }
        WriteTransaction wtx = this.dataBroker.newWriteOnlyTransaction();
        bindingsMap.entrySet().forEach(bindingEntries -> {
            String domainId = (String)bindingEntries.getKey();
            ((Multimap)bindingEntries.getValue()).entries().forEach(binding -> this.writeBinding((Map.Entry<Sgt, IpPrefix>)binding, domainId, wtx));
        });
        CheckedFuture submit = wtx.submit();
        final SettableFuture future = SettableFuture.create();
        Futures.addCallback((ListenableFuture)submit, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(Void result) {
                future.set((Object)RpcResultBuilder.success().build());
            }

            public void onFailure(Throwable t) {
                future.set((Object)RpcResultBuilder.failed().build());
            }
        });
        return future;
    }

    private boolean transformChanges(Binding binding, Map<String, Multimap<Sgt, IpPrefix>> bindingsMap) {
        Sgt sgt = binding.getSgt();
        IpPrefix addr = binding.getIpPrefix();
        for (PeerNode peer : binding.getPeerNode()) {
            String domainId = this.nodeCollector.getDomainIdForPeer(peer.getNodeIid());
            if (domainId == null) {
                LOG.debug("Node {} is not SXP capable", peer.getNodeIid());
                return false;
            }
            ArrayListMultimap domainBindingMap = bindingsMap.get(domainId);
            if (domainBindingMap == null) {
                domainBindingMap = ArrayListMultimap.create();
                bindingsMap.put(domainId, (Multimap<Sgt, IpPrefix>)domainBindingMap);
            }
            domainBindingMap.get((Object)sgt).add(addr);
        }
        return true;
    }

    private void writeBinding(Map.Entry<Sgt, IpPrefix> binding, String domainId, WriteTransaction wtx) {
        IpPrefix addr = binding.getValue();
        InstanceIdentifier<MasterDatabaseBinding> iid = this.bindingIid(domainId, addr);
        MasterDatabaseBinding newBinding = this.createBinding(binding);
        wtx.put(LogicalDatastoreType.CONFIGURATION, iid, (DataObject)newBinding);
    }

    private InstanceIdentifier<MasterDatabaseBinding> bindingIid(String domainId, IpPrefix prefix) {
        return InstanceIdentifier.builder(NetworkTopology.class).child(Topology.class, (Identifier)new TopologyKey(new TopologyId(SXP_TOPOLOGY_ID))).child(Node.class, (Identifier)new NodeKey(new org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId(this.SXP_NODE_ID))).augmentation(SxpNodeIdentity.class).child(SxpDomains.class).child(SxpDomain.class, (Identifier)new SxpDomainKey(domainId)).child(MasterDatabase.class).child(MasterDatabaseBinding.class, (Identifier)new MasterDatabaseBindingKey(prefix)).build();
    }

    private MasterDatabaseBinding createBinding(Map.Entry<Sgt, IpPrefix> binding) {
        DateAndTime nowDateTime = TimeConv.toDt((long)System.currentTimeMillis());
        return new MasterDatabaseBindingBuilder().setIpPrefix(binding.getValue()).setSecurityGroupTag(binding.getKey()).setPeerSequence(new PeerSequenceBuilder().build()).setTimestamp(nowDateTime).build();
    }

    @Override
    public Future<RpcResult<Void>> removeIpSgtBindingFromPeer(RemoveIpSgtBindingFromPeerInput input) {
        Binding binding;
        HashMap<String, Multimap<Sgt, IpPrefix>> bindingsMap = new HashMap<String, Multimap<Sgt, IpPrefix>>();
        boolean success = true;
        Iterator<Binding> iterator = input.getBinding().iterator();
        while (iterator.hasNext() && (success = this.transformChanges(binding = iterator.next(), bindingsMap))) {
        }
        if (!success) {
            return Futures.immediateCheckedFuture((Object)RpcResultBuilder.failed().build());
        }
        WriteTransaction wtx = this.dataBroker.newWriteOnlyTransaction();
        bindingsMap.entrySet().forEach(bindingEntries -> {
            String domainId = (String)bindingEntries.getKey();
            ((Multimap)bindingEntries.getValue()).entries().forEach(binding -> this.removeBinding((Map.Entry<Sgt, IpPrefix>)binding, domainId, wtx));
        });
        CheckedFuture submit = wtx.submit();
        final SettableFuture future = SettableFuture.create();
        Futures.addCallback((ListenableFuture)submit, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(Void result) {
                future.set((Object)RpcResultBuilder.success().build());
            }

            public void onFailure(Throwable t) {
                future.set((Object)RpcResultBuilder.failed().build());
            }
        });
        return future;
    }

    private void removeBinding(Map.Entry<Sgt, IpPrefix> binding, String domainId, WriteTransaction wtx) {
        IpPrefix addr = binding.getValue();
        InstanceIdentifier<MasterDatabaseBinding> iid = this.bindingIid(domainId, addr);
        wtx.delete(LogicalDatastoreType.CONFIGURATION, iid);
    }

    @Override
    public void close() throws Exception {
        this.nodeCollector.close();
    }
}

