/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.config.ip.sgt.distribution.service.cfg;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Future;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.controller.sal.binding.api.RpcProviderRegistry;
import org.opendaylight.groupbasedpolicy.ip.sgt.distribution.service.impl.IpSgtDistributionServiceImpl;
import org.opendaylight.mdsal.singleton.common.api.ClusterSingletonService;
import org.opendaylight.mdsal.singleton.common.api.ClusterSingletonServiceProvider;
import org.opendaylight.mdsal.singleton.common.api.ClusterSingletonServiceRegistration;
import org.opendaylight.mdsal.singleton.common.api.ServiceGroupIdentifier;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715.IpSgtDistributionService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715.RemoveIpSgtBindingFromPeerInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715.SendIpSgtBindingToPeerInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.controller.rev141002.SxpControllerService;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpSgtDistributionServiceInstance
implements ClusterSingletonService,
IpSgtDistributionService,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(IpSgtDistributionServiceInstance.class);
    private static final ServiceGroupIdentifier IDENTIFIER = ServiceGroupIdentifier.create((String)"gbp-service-group-identifier");
    private IpSgtDistributionServiceImpl ipSgtDistributionServiceImpl;
    private final DataBroker dataBroker;
    private final SxpControllerService sxpService;
    private final IpAddress sourceIp;
    private final ClusterSingletonServiceProvider clusterSingletonService;
    private final RpcProviderRegistry rpcProviderRegistry;
    private ClusterSingletonServiceRegistration singletonServiceRegistration;
    private BindingAwareBroker.RpcRegistration<IpSgtDistributionService> rpcRegistration;

    public IpSgtDistributionServiceInstance(DataBroker dataBroker, String sourceIp, ClusterSingletonServiceProvider clusterSingletonService, RpcProviderRegistry rpcProviderRegistry) {
        this.dataBroker = (DataBroker)Preconditions.checkNotNull((Object)dataBroker);
        this.sxpService = (SxpControllerService)Preconditions.checkNotNull((Object)rpcProviderRegistry.getRpcService(SxpControllerService.class));
        this.sourceIp = new IpAddress((char[])Preconditions.checkNotNull((Object)sourceIp.toCharArray()));
        this.clusterSingletonService = (ClusterSingletonServiceProvider)Preconditions.checkNotNull((Object)clusterSingletonService);
        this.rpcProviderRegistry = (RpcProviderRegistry)Preconditions.checkNotNull((Object)rpcProviderRegistry);
    }

    public void initialize() {
        LOG.info("Clustering session initiated for {}", (Object)this.getClass().getSimpleName());
        this.singletonServiceRegistration = this.clusterSingletonService.registerClusterSingletonService((ClusterSingletonService)this);
    }

    public ServiceGroupIdentifier getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public void close() throws Exception {
        LOG.info("Clustering provider closed for {}", (Object)this.getClass().getSimpleName());
        if (this.singletonServiceRegistration != null) {
            try {
                this.singletonServiceRegistration.close();
            }
            catch (Exception e) {
                LOG.warn("{} closed unexpectedly", (Object)this.getClass().getSimpleName(), (Object)e);
            }
            this.singletonServiceRegistration = null;
        }
    }

    @Override
    public Future<RpcResult<Void>> removeIpSgtBindingFromPeer(RemoveIpSgtBindingFromPeerInput input) {
        return this.ipSgtDistributionServiceImpl.removeIpSgtBindingFromPeer(input);
    }

    @Override
    public Future<RpcResult<Void>> sendIpSgtBindingToPeer(SendIpSgtBindingToPeerInput input) {
        return this.ipSgtDistributionServiceImpl.sendIpSgtBindingToPeer(input);
    }

    public ListenableFuture<Void> closeServiceInstance() {
        LOG.info("Instance {} closed", (Object)this.getClass().getSimpleName());
        try {
            this.ipSgtDistributionServiceImpl.close();
            this.rpcRegistration.close();
        }
        catch (Exception e) {
            LOG.error("Closing {} wasnt succesfull", (Object)this.ipSgtDistributionServiceImpl.getClass().getSimpleName());
        }
        return Futures.immediateFuture(null);
    }

    public void instantiateServiceInstance() {
        this.ipSgtDistributionServiceImpl = new IpSgtDistributionServiceImpl(this.dataBroker, this.sxpService, this.sourceIp);
        this.rpcRegistration = this.rpcProviderRegistry.addRpcImplementation(IpSgtDistributionService.class, (RpcService)this);
    }
}

