package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715.rpc.fields.binding;
import org.opendaylight.yangtools.yang.binding.Identifier;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public class PeerNodeKey
 implements Identifier<PeerNode> {
    private static final long serialVersionUID = 531660107079984758L;
    private final InstanceIdentifier<?> _nodeIid;


    public PeerNodeKey(InstanceIdentifier<?> _nodeIid) {
    
    
        this._nodeIid = _nodeIid;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public PeerNodeKey(PeerNodeKey source) {
        this._nodeIid = source._nodeIid;
    }


    public InstanceIdentifier<?> getNodeIid() {
        return _nodeIid;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_nodeIid);
        return result;
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        PeerNodeKey other = (PeerNodeKey) obj;
        if (!Objects.equals(_nodeIid, other._nodeIid)) {
            return false;
        }
        return true;
    }

    @Override
    public java.lang.String toString() {
        java.lang.StringBuilder builder = new java.lang.StringBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715.rpc.fields.binding.PeerNodeKey.class.getSimpleName()).append(" [");
        boolean first = true;
    
        if (_nodeIid != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_nodeIid=");
            builder.append(_nodeIid);
         }
        return builder.append(']').toString();
    }
}

