package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715.rpc.fields;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.database.rev160308.Sgt;
import org.opendaylight.yangtools.yang.binding.Identifier;
import java.util.Objects;

public class BindingKey
 implements Identifier<Binding> {
    private static final long serialVersionUID = 6083269498906845352L;
    private final Sgt _sgt;
    private final IpPrefix _ipPrefix;


    public BindingKey(IpPrefix _ipPrefix, Sgt _sgt) {
    
    
        this._sgt = _sgt;
        this._ipPrefix = _ipPrefix;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public BindingKey(BindingKey source) {
        this._sgt = source._sgt;
        this._ipPrefix = source._ipPrefix;
    }


    public Sgt getSgt() {
        return _sgt;
    }
    
    public IpPrefix getIpPrefix() {
        return _ipPrefix;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_sgt);
        result = prime * result + Objects.hashCode(_ipPrefix);
        return result;
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        BindingKey other = (BindingKey) obj;
        if (!Objects.equals(_sgt, other._sgt)) {
            return false;
        }
        if (!Objects.equals(_ipPrefix, other._ipPrefix)) {
            return false;
        }
        return true;
    }

    @Override
    public java.lang.String toString() {
        java.lang.StringBuilder builder = new java.lang.StringBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715.rpc.fields.BindingKey.class.getSimpleName()).append(" [");
        boolean first = true;
    
        if (_sgt != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_sgt=");
            builder.append(_sgt);
         }
        if (_ipPrefix != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_ipPrefix=");
            builder.append(_ipPrefix);
         }
        return builder.append(']').toString();
    }
}

