package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715.rpc.fields;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.database.rev160308.Sgt;
import org.opendaylight.yangtools.yang.common.QName;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715.RpcFields;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715.rpc.fields.binding.PeerNode;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Identifiable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>ip-sgt-distribution</b>
 * <pre>
 * list binding {
 *     key "sgt" 
 * "ip-prefix"
 *     leaf sgt {
 *         type sgt;
 *     }
 *     leaf ip-prefix {
 *         type ip-prefix;
 *     }
 *     list peer-node {
 *         key "node-iid"
 *         leaf node-iid {
 *             type instance-identifier;
 *         }
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>ip-sgt-distribution/rpc-fields/binding</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715.rpc.fields.BindingBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715.rpc.fields.BindingBuilder
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715.rpc.fields.BindingKey
 *
 */
public interface Binding
    extends
    ChildOf<RpcFields>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715.rpc.fields.Binding>,
    Identifiable<BindingKey>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:config:ip:sgt:distribution",
        "2016-07-15", "binding").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.database.rev160308.Sgt</code> <code>sgt</code>, or <code>null</code> if not present
     */
    Sgt getSgt();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix</code> <code>ipPrefix</code>, or <code>null</code> if not present
     */
    IpPrefix getIpPrefix();
    
    /**
     * @return <code>java.util.List</code> <code>peerNode</code>, or <code>null</code> if not present
     */
    List<PeerNode> getPeerNode();
    
    /**
     * Returns Primary Key of Yang List Type
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715.rpc.fields.BindingKey</code> <code>key</code>, or <code>null</code> if not present
     */
    BindingKey getKey();

}

