package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715.sxp.connection.fields.SxpConnection;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>ip-sgt-distribution</b>
 * <pre>
 * grouping sxp-connection-fields {
 *     container sxp-connection {
 *         leaf ip-address {
 *             type ip-address;
 *         }
 *         leaf port-number {
 *             type port-number;
 *         }
 *         leaf password {
 *             type string;
 *         }
 *         leaf version {
 *             type version;
 *         }
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>ip-sgt-distribution/sxp-connection-fields</i>
 *
 */
public interface SxpConnectionFields
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:config:ip:sgt:distribution",
        "2016-07-15", "sxp-connection-fields").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715.sxp.connection.fields.SxpConnection</code> <code>sxpConnection</code>, or <code>null</code> if not present
     */
    SxpConnection getSxpConnection();

}

