package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715.rpc.fields.Binding;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import java.util.List;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>ip-sgt-distribution</b>
 * <pre>
 * grouping rpc-fields {
 *     list binding {
 *         key "sgt" 
 *     "ip-prefix"
 *         leaf sgt {
 *             type sgt;
 *         }
 *         leaf ip-prefix {
 *             type ip-prefix;
 *         }
 *         list peer-node {
 *             key "node-iid"
 *             leaf node-iid {
 *                 type instance-identifier;
 *             }
 *         }
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>ip-sgt-distribution/rpc-fields</i>
 *
 */
public interface RpcFields
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:config:ip:sgt:distribution",
        "2016-07-15", "rpc-fields").intern();

    /**
     * @return <code>java.util.List</code> <code>binding</code>, or <code>null</code> if not present
     */
    List<Binding> getBinding();

}

