package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>ip-sgt-distribution</b>
 * <pre>
 * container input {
 *     list binding {
 *         key "sgt" 
 *     "ip-prefix"
 *         leaf sgt {
 *             type sgt;
 *         }
 *         leaf ip-prefix {
 *             type ip-prefix;
 *         }
 *         list peer-node {
 *             key "node-iid"
 *             leaf node-iid {
 *                 type instance-identifier;
 *             }
 *         }
 *     }
 *     uses rpc-fields;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>ip-sgt-distribution/remove-ip-sgt-binding-from-peer/input</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715.RemoveIpSgtBindingFromPeerInputBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715.RemoveIpSgtBindingFromPeerInputBuilder
 *
 */
public interface RemoveIpSgtBindingFromPeerInput
    extends
    RpcFields,
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715.RemoveIpSgtBindingFromPeerInput>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:config:ip:sgt:distribution",
        "2016-07-15", "input").intern();


}

