package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;
import java.util.concurrent.Future;

/**
 * Interface for implementing the following YANG RPCs defined in module <b>ip-sgt-distribution</b>
 * <pre>
 * rpc remove-ip-sgt-binding-from-peer {
 *     input {
 *         list binding {
 *             key "sgt" 
 *         "ip-prefix"
 *             leaf sgt {
 *                 type sgt;
 *             }
 *             leaf ip-prefix {
 *                 type ip-prefix;
 *             }
 *             list peer-node {
 *                 key "node-iid"
 *                 leaf node-iid {
 *                     type instance-identifier;
 *                 }
 *             }
 *         }
 *     }
 *     
 *     output {
 *     }
 * }
 * rpc send-ip-sgt-binding-to-peer {
 *     input {
 *         list binding {
 *             key "sgt" 
 *         "ip-prefix"
 *             leaf sgt {
 *                 type sgt;
 *             }
 *             leaf ip-prefix {
 *                 type ip-prefix;
 *             }
 *             list peer-node {
 *                 key "node-iid"
 *                 leaf node-iid {
 *                     type instance-identifier;
 *                 }
 *             }
 *         }
 *     }
 *     
 *     output {
 *     }
 * }
 * </pre>
 *
 */
public interface IpSgtDistributionService
    extends
    RpcService
{




    Future<RpcResult<java.lang.Void>> removeIpSgtBindingFromPeer(RemoveIpSgtBindingFromPeerInput input);
    
    Future<RpcResult<java.lang.Void>> sendIpSgtBindingToPeer(SendIpSgtBindingToPeerInput input);

}

