/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715.sxp.connection.fields;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715.sxp.connection.fields.SxpConnection;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.protocol.rev141002.Version;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SxpConnectionBuilder
implements Builder<SxpConnection> {
    private IpAddress _ipAddress;
    private String _password;
    private PortNumber _portNumber;
    private Version _version;
    Map<Class<? extends Augmentation<SxpConnection>>, Augmentation<SxpConnection>> augmentation = Collections.emptyMap();

    public SxpConnectionBuilder() {
    }

    public SxpConnectionBuilder(SxpConnection base) {
        AugmentationHolder casted;
        this._ipAddress = base.getIpAddress();
        this._password = base.getPassword();
        this._portNumber = base.getPortNumber();
        this._version = base.getVersion();
        if (base instanceof SxpConnectionImpl) {
            SxpConnectionImpl impl = (SxpConnectionImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<SxpConnection>>, Augmentation<SxpConnection>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SxpConnection>>, Augmentation<SxpConnection>>(casted.augmentations());
        }
    }

    public IpAddress getIpAddress() {
        return this._ipAddress;
    }

    public String getPassword() {
        return this._password;
    }

    public PortNumber getPortNumber() {
        return this._portNumber;
    }

    public Version getVersion() {
        return this._version;
    }

    public <E extends Augmentation<SxpConnection>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public SxpConnectionBuilder setIpAddress(IpAddress value) {
        this._ipAddress = value;
        return this;
    }

    public SxpConnectionBuilder setPassword(String value) {
        this._password = value;
        return this;
    }

    public SxpConnectionBuilder setPortNumber(PortNumber value) {
        this._portNumber = value;
        return this;
    }

    public SxpConnectionBuilder setVersion(Version value) {
        this._version = value;
        return this;
    }

    public SxpConnectionBuilder addAugmentation(Class<? extends Augmentation<SxpConnection>> augmentationType, Augmentation<SxpConnection> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SxpConnection>>, Augmentation<SxpConnection>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public SxpConnectionBuilder removeAugmentation(Class<? extends Augmentation<SxpConnection>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public SxpConnection build() {
        return new SxpConnectionImpl(this);
    }

    private static final class SxpConnectionImpl
    implements SxpConnection {
        private final IpAddress _ipAddress;
        private final String _password;
        private final PortNumber _portNumber;
        private final Version _version;
        private Map<Class<? extends Augmentation<SxpConnection>>, Augmentation<SxpConnection>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<SxpConnection> getImplementedInterface() {
            return SxpConnection.class;
        }

        private SxpConnectionImpl(SxpConnectionBuilder base) {
            this._ipAddress = base.getIpAddress();
            this._password = base.getPassword();
            this._portNumber = base.getPortNumber();
            this._version = base.getVersion();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<SxpConnection>>, Augmentation<SxpConnection>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<SxpConnection>>, Augmentation<SxpConnection>>(base.augmentation);
                }
            }
        }

        @Override
        public IpAddress getIpAddress() {
            return this._ipAddress;
        }

        @Override
        public String getPassword() {
            return this._password;
        }

        @Override
        public PortNumber getPortNumber() {
            return this._portNumber;
        }

        @Override
        public Version getVersion() {
            return this._version;
        }

        public <E extends Augmentation<SxpConnection>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ipAddress);
            result = 31 * result + Objects.hashCode(this._password);
            result = 31 * result + Objects.hashCode(this._portNumber);
            result = 31 * result + Objects.hashCode(this._version);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SxpConnection.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SxpConnection other = (SxpConnection)obj;
            if (!Objects.equals(this._ipAddress, other.getIpAddress())) {
                return false;
            }
            if (!Objects.equals(this._password, other.getPassword())) {
                return false;
            }
            if (!Objects.equals(this._portNumber, other.getPortNumber())) {
                return false;
            }
            if (!Objects.equals(this._version, other.getVersion())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SxpConnectionImpl otherImpl = (SxpConnectionImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<SxpConnection>>, Augmentation<SxpConnection>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("SxpConnection [");
            boolean first = true;
            if (this._ipAddress != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ipAddress=");
                builder.append(this._ipAddress);
            }
            if (this._password != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_password=");
                builder.append(this._password);
            }
            if (this._portNumber != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_portNumber=");
                builder.append(this._portNumber);
            }
            if (this._version != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_version=");
                builder.append(this._version);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

