/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715.rpc.fields.binding;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715.rpc.fields.binding.PeerNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715.rpc.fields.binding.PeerNodeKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public class PeerNodeBuilder
implements Builder<PeerNode> {
    private PeerNodeKey _key;
    private InstanceIdentifier<?> _nodeIid;
    Map<Class<? extends Augmentation<PeerNode>>, Augmentation<PeerNode>> augmentation = Collections.emptyMap();

    public PeerNodeBuilder() {
    }

    public PeerNodeBuilder(PeerNode base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new PeerNodeKey(base.getNodeIid());
            this._nodeIid = base.getNodeIid();
        } else {
            this._key = base.getKey();
            this._nodeIid = this._key.getNodeIid();
        }
        if (base instanceof PeerNodeImpl) {
            PeerNodeImpl impl = (PeerNodeImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PeerNode>>, Augmentation<PeerNode>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PeerNode>>, Augmentation<PeerNode>>(casted.augmentations());
        }
    }

    public PeerNodeKey getKey() {
        return this._key;
    }

    public InstanceIdentifier<?> getNodeIid() {
        return this._nodeIid;
    }

    public <E extends Augmentation<PeerNode>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PeerNodeBuilder setKey(PeerNodeKey value) {
        this._key = value;
        return this;
    }

    public PeerNodeBuilder setNodeIid(InstanceIdentifier<?> value) {
        this._nodeIid = value;
        return this;
    }

    public PeerNodeBuilder addAugmentation(Class<? extends Augmentation<PeerNode>> augmentationType, Augmentation<PeerNode> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PeerNode>>, Augmentation<PeerNode>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PeerNodeBuilder removeAugmentation(Class<? extends Augmentation<PeerNode>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PeerNode build() {
        return new PeerNodeImpl(this);
    }

    private static final class PeerNodeImpl
    implements PeerNode {
        private final PeerNodeKey _key;
        private final InstanceIdentifier<?> _nodeIid;
        private Map<Class<? extends Augmentation<PeerNode>>, Augmentation<PeerNode>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<PeerNode> getImplementedInterface() {
            return PeerNode.class;
        }

        private PeerNodeImpl(PeerNodeBuilder base) {
            if (base.getKey() == null) {
                this._key = new PeerNodeKey(base.getNodeIid());
                this._nodeIid = base.getNodeIid();
            } else {
                this._key = base.getKey();
                this._nodeIid = this._key.getNodeIid();
            }
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PeerNode>>, Augmentation<PeerNode>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PeerNode>>, Augmentation<PeerNode>>(base.augmentation);
                }
            }
        }

        @Override
        public PeerNodeKey getKey() {
            return this._key;
        }

        @Override
        public InstanceIdentifier<?> getNodeIid() {
            return this._nodeIid;
        }

        public <E extends Augmentation<PeerNode>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._nodeIid);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PeerNode.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PeerNode other = (PeerNode)obj;
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._nodeIid, other.getNodeIid())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PeerNodeImpl otherImpl = (PeerNodeImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PeerNode>>, Augmentation<PeerNode>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("PeerNode [");
            boolean first = true;
            if (this._key != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_key=");
                builder.append(this._key);
            }
            if (this._nodeIid != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nodeIid=");
                builder.append(this._nodeIid);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

