/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715.rpc.fields;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715.rpc.fields.Binding;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715.rpc.fields.BindingKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.ip.sgt.distribution.rev160715.rpc.fields.binding.PeerNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.database.rev160308.Sgt;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class BindingBuilder
implements Builder<Binding> {
    private IpPrefix _ipPrefix;
    private BindingKey _key;
    private List<PeerNode> _peerNode;
    private Sgt _sgt;
    Map<Class<? extends Augmentation<Binding>>, Augmentation<Binding>> augmentation = Collections.emptyMap();

    public BindingBuilder() {
    }

    public BindingBuilder(Binding base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new BindingKey(base.getIpPrefix(), base.getSgt());
            this._ipPrefix = base.getIpPrefix();
            this._sgt = base.getSgt();
        } else {
            this._key = base.getKey();
            this._ipPrefix = this._key.getIpPrefix();
            this._sgt = this._key.getSgt();
        }
        this._peerNode = base.getPeerNode();
        if (base instanceof BindingImpl) {
            BindingImpl impl = (BindingImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Binding>>, Augmentation<Binding>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Binding>>, Augmentation<Binding>>(casted.augmentations());
        }
    }

    public IpPrefix getIpPrefix() {
        return this._ipPrefix;
    }

    public BindingKey getKey() {
        return this._key;
    }

    public List<PeerNode> getPeerNode() {
        return this._peerNode;
    }

    public Sgt getSgt() {
        return this._sgt;
    }

    public <E extends Augmentation<Binding>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public BindingBuilder setIpPrefix(IpPrefix value) {
        this._ipPrefix = value;
        return this;
    }

    public BindingBuilder setKey(BindingKey value) {
        this._key = value;
        return this;
    }

    public BindingBuilder setPeerNode(List<PeerNode> value) {
        this._peerNode = value;
        return this;
    }

    public BindingBuilder setSgt(Sgt value) {
        this._sgt = value;
        return this;
    }

    public BindingBuilder addAugmentation(Class<? extends Augmentation<Binding>> augmentationType, Augmentation<Binding> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Binding>>, Augmentation<Binding>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public BindingBuilder removeAugmentation(Class<? extends Augmentation<Binding>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Binding build() {
        return new BindingImpl(this);
    }

    private static final class BindingImpl
    implements Binding {
        private final IpPrefix _ipPrefix;
        private final BindingKey _key;
        private final List<PeerNode> _peerNode;
        private final Sgt _sgt;
        private Map<Class<? extends Augmentation<Binding>>, Augmentation<Binding>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Binding> getImplementedInterface() {
            return Binding.class;
        }

        private BindingImpl(BindingBuilder base) {
            if (base.getKey() == null) {
                this._key = new BindingKey(base.getIpPrefix(), base.getSgt());
                this._ipPrefix = base.getIpPrefix();
                this._sgt = base.getSgt();
            } else {
                this._key = base.getKey();
                this._ipPrefix = this._key.getIpPrefix();
                this._sgt = this._key.getSgt();
            }
            this._peerNode = base.getPeerNode();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Binding>>, Augmentation<Binding>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Binding>>, Augmentation<Binding>>(base.augmentation);
                }
            }
        }

        @Override
        public IpPrefix getIpPrefix() {
            return this._ipPrefix;
        }

        @Override
        public BindingKey getKey() {
            return this._key;
        }

        @Override
        public List<PeerNode> getPeerNode() {
            return this._peerNode;
        }

        @Override
        public Sgt getSgt() {
            return this._sgt;
        }

        public <E extends Augmentation<Binding>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ipPrefix);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._peerNode);
            result = 31 * result + Objects.hashCode(this._sgt);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Binding.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Binding other = (Binding)obj;
            if (!Objects.equals(this._ipPrefix, other.getIpPrefix())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._peerNode, other.getPeerNode())) {
                return false;
            }
            if (!Objects.equals(this._sgt, other.getSgt())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                BindingImpl otherImpl = (BindingImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Binding>>, Augmentation<Binding>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Binding [");
            boolean first = true;
            if (this._ipPrefix != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ipPrefix=");
                builder.append(this._ipPrefix);
            }
            if (this._key != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_key=");
                builder.append(this._key);
            }
            if (this._peerNode != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_peerNode=");
                builder.append(this._peerNode);
            }
            if (this._sgt != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_sgt=");
                builder.append(this._sgt);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

