/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.defense4all.restservice;

import java.util.Hashtable;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opendaylight.defense4all.core.DFHolder;
import org.opendaylight.defense4all.core.OFC;
import org.opendaylight.defense4all.framework.core.ExceptionControlApp;
import org.opendaylight.defense4all.framework.core.Repo;

public class OFCResource {
    private static Log log = LogFactory.getLog(OFCResource.class);
    @Context
    UriInfo uriInfo;
    @Context
    Request request;
    String ofcLabel;

    public OFCResource(UriInfo uriInfo, Request request, String ofcLabel) {
        this.uriInfo = uriInfo;
        this.request = request;
        this.ofcLabel = ofcLabel;
    }

    @GET
    @Produces(value={"application/json"})
    public OFC getOFC() {
        try {
            log.debug((Object)("In getOFC. OFC label is " + this.ofcLabel));
            Repo oFCsRepo = DFHolder.get().oFCsRepo;
            Hashtable ofcRow = oFCsRepo.getRow((Object)this.ofcLabel);
            if (ofcRow == null) {
                return null;
            }
            return new OFC(ofcRow);
        }
        catch (ExceptionControlApp e) {
            log.error((Object)("Failed to retrieve ofc " + this.ofcLabel), (Throwable)e);
            return null;
        }
    }

    @DELETE
    public void deleteOFC() {
        try {
            log.debug((Object)"DeleteOFC: invoked");
            DFHolder.get().getMgmtPoint().removeOFC(this.ofcLabel);
        }
        catch (ExceptionControlApp exceptionControlApp) {
            // empty catch block
        }
    }
}

