/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.defense4all.restservice;

import java.util.Hashtable;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opendaylight.defense4all.core.AMS;
import org.opendaylight.defense4all.core.DFHolder;
import org.opendaylight.defense4all.framework.core.ExceptionControlApp;
import org.opendaylight.defense4all.framework.core.Repo;

public class AmsResource {
    private static Log log = LogFactory.getLog(AmsResource.class);
    @Context
    UriInfo uriInfo;
    @Context
    Request request;
    String amsLabel;

    public AmsResource(UriInfo uriInfo, Request request, String amsLabel) {
        this.uriInfo = uriInfo;
        this.request = request;
        this.amsLabel = amsLabel;
    }

    @GET
    @Produces(value={"application/json"})
    public AMS getAms() throws ExceptionControlApp {
        try {
            log.debug((Object)("In getAms. ams label is " + this.amsLabel));
            Repo amsRepo = DFHolder.get().amsRepo;
            log.debug((Object)("In getAms. amsRepo is " + amsRepo));
            Hashtable amsRow = amsRepo.getRow((Object)this.amsLabel);
            if (amsRow == null) {
                return null;
            }
            return new AMS(amsRow);
        }
        catch (Throwable e) {
            log.error((Object)("Failed to retrieve pn " + this.amsLabel), e);
            return null;
        }
    }

    @DELETE
    public AMSResourceStatus deleteAms() {
        try {
            log.debug((Object)"DeleteAms: invoked");
            boolean success = DFHolder.get().getMgmtPoint().removeAMS(this.amsLabel);
            return success ? AMSResourceStatus.OK : AMSResourceStatus.CONFLICT;
        }
        catch (ExceptionControlApp e) {
            log.error((Object)("Failed to delete AMS " + this.amsLabel), (Throwable)e);
            return AMSResourceStatus.SERVER_ERROR;
        }
    }

    public static enum AMSResourceStatus {
        OK,
        CONFLICT,
        SERVER_ERROR;

    }
}

