/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.defense4all.restservice;

import java.net.URI;
import java.util.Hashtable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opendaylight.defense4all.core.DFHolder;
import org.opendaylight.defense4all.core.PO;
import org.opendaylight.defense4all.framework.core.ExceptionControlApp;
import org.opendaylight.defense4all.framework.core.Repo;

public class POResource {
    private static Log log = LogFactory.getLog(POResource.class);
    @Context
    UriInfo uriInfo;
    @Context
    Request request;
    String poLabel;

    public POResource(UriInfo uriInfo, Request request, String poLabel) {
        this.uriInfo = uriInfo;
        this.request = request;
        this.poLabel = poLabel;
    }

    @GET
    @Produces(value={"application/json"})
    public PO getPO() {
        try {
            log.debug((Object)("In getPO. PO label is " + this.poLabel));
            Hashtable poRow = DFHolder.get().posRepo.getRow((Object)this.poLabel);
            if (poRow == null) {
                return null;
            }
            return new PO(poRow);
        }
        catch (ExceptionControlApp e) {
            log.error((Object)("Failed to retrieve po " + this.poLabel), (Throwable)e);
            return null;
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response putPO(JAXBElement<PO> jaxbPO) {
        try {
            Response res;
            PO po = (PO)jaxbPO.getValue();
            Repo posRepo = DFHolder.get().posRepo;
            if (posRepo.getRow((Object)this.poLabel) != null) {
                res = Response.noContent().build();
            } else {
                res = Response.created((URI)this.uriInfo.getAbsolutePath()).build();
                DFHolder.get().posRepo.setRow((Object)po.label, po.toRow());
            }
            return res;
        }
        catch (ExceptionControlApp e) {
            log.error((Object)("Failed to retrieve po " + this.poLabel), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @DELETE
    public void deletePO() {
        try {
            log.debug((Object)"DeletePO: invoked");
            DFHolder.get().posRepo.deleteRow((Object)this.poLabel);
        }
        catch (ExceptionControlApp e) {
            log.error((Object)("Failed to delete po " + this.poLabel), (Throwable)e);
        }
    }
}

