/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.defense4all.restservice;

import java.util.Hashtable;
import javax.transaction.NotSupportedException;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opendaylight.defense4all.core.DFHolder;
import org.opendaylight.defense4all.core.NetNode;
import org.opendaylight.defense4all.framework.core.ExceptionControlApp;
import org.opendaylight.defense4all.framework.core.Repo;

public class NetNodeResource {
    private static Log log = LogFactory.getLog(NetNodeResource.class);
    @Context
    UriInfo uriInfo;
    @Context
    Request request;
    String netNodeLabel;

    public NetNodeResource(UriInfo uriInfo, Request request, String netNodeLabel) {
        this.uriInfo = uriInfo;
        this.request = request;
        this.netNodeLabel = netNodeLabel;
    }

    @GET
    @Produces(value={"application/json"})
    public NetNode getNetNode() {
        try {
            log.debug((Object)("In getnetNode. NetNode label is " + this.netNodeLabel));
            Repo netNodesRepo = DFHolder.get().netNodesRepo;
            Hashtable netNodeRow = netNodesRepo.getRow((Object)this.netNodeLabel);
            if (netNodeRow == null) {
                return null;
            }
            NetNode netNode = new NetNode(netNodeRow);
            netNode.toJacksonFriendly();
            return netNode;
        }
        catch (ExceptionControlApp e) {
            log.error((Object)("Failed to retrieve pn " + this.netNodeLabel), (Throwable)e);
            return null;
        }
    }

    @DELETE
    public NetNodeResourceStatus deleteNetNode() {
        try {
            log.debug((Object)"DeleteNetNode: invoked");
            DFHolder.get().getMgmtPoint().removeNetNode(this.netNodeLabel);
            return NetNodeResourceStatus.OK;
        }
        catch (NotSupportedException e2) {
            return NetNodeResourceStatus.FORBIDDEN;
        }
        catch (IllegalStateException e1) {
            return NetNodeResourceStatus.CONFLICT;
        }
        catch (ExceptionControlApp e) {
            return NetNodeResourceStatus.SERVER_ERROR;
        }
    }

    public static enum NetNodeResourceStatus {
        OK,
        FORBIDDEN,
        CONFLICT,
        SERVER_ERROR;

    }
}

