/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.defense4all.restservice;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.transaction.NotSupportedException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.UriInfo;
import org.opendaylight.defense4all.core.AMS;
import org.opendaylight.defense4all.core.Attack;
import org.opendaylight.defense4all.core.DFHolder;
import org.opendaylight.defense4all.core.Mitigation;
import org.opendaylight.defense4all.core.NetNode;
import org.opendaylight.defense4all.core.OFC;
import org.opendaylight.defense4all.core.PN;
import org.opendaylight.defense4all.core.PO;
import org.opendaylight.defense4all.core.interactionstructures.PNStatReport;
import org.opendaylight.defense4all.framework.core.FMHolder;
import org.opendaylight.defense4all.framework.core.Repo;
import org.opendaylight.defense4all.restservice.AmsResource;
import org.opendaylight.defense4all.restservice.NetNodeResource;
import org.opendaylight.defense4all.restservice.OFCResource;
import org.opendaylight.defense4all.restservice.PNResource;
import org.opendaylight.defense4all.restservice.POResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/df")
public class Defense4allRestService {
    private static Logger log = LoggerFactory.getLogger((String)"org.opendaylight.defense4all.restservice");
    @Context
    UriInfo uriInfo;
    @Context
    Request request;

    @GET
    @Path(value="pos")
    @Produces(value={"application/json"})
    public Collection<PO> getPOs(@Context HttpServletResponse servletResponse) {
        if (!FMHolder.get().isOpenForBusiness()) {
            try {
                servletResponse.sendError(503, "Service is unavailable");
            }
            catch (Throwable e) {
                log.error("Error in response " + e);
            }
            return null;
        }
        ArrayList<PO> poList = new ArrayList<PO>();
        try {
            log.debug("getPOs: Invoked");
            Repo posRepo = DFHolder.get().posRepo;
            Hashtable res = posRepo.getTable();
            if (res == null) {
                return poList;
            }
            Collection poResList = res.values();
            Iterator i = poResList.iterator();
            while (i.hasNext()) {
                poList.add(new PO((Hashtable)i.next()));
            }
            return poList;
        }
        catch (Throwable e) {
            log.error("Failed to retrieve pos. ", e);
            return poList;
        }
    }

    @GET
    @Path(value="pos/count")
    @Produces(value={"application/json"})
    public String getPOsCount(@Context HttpServletResponse servletResponse) {
        log.debug("getPOsCount: invoked");
        if (!FMHolder.get().isOpenForBusiness()) {
            try {
                servletResponse.sendError(503, "Service is unavailable");
            }
            catch (Throwable e) {
                log.error("Error in response " + e);
            }
            return null;
        }
        try {
            Repo posRepo = DFHolder.get().posRepo;
            int count = posRepo.getKeys().size();
            return String.valueOf(count);
        }
        catch (Throwable e) {
            log.error("Failed to retrieve POs count");
            return null;
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="pos/{po}")
    public PO getPO(@PathParam(value="po") String poLabel, @Context HttpServletResponse servletResponse) {
        log.debug("getPO: invoked");
        if (!FMHolder.get().isOpenForBusiness()) {
            try {
                servletResponse.sendError(503, "Service is unavailable");
            }
            catch (Throwable e) {
                log.error("Error in response " + e);
            }
            return null;
        }
        POResource poResource = new POResource(this.uriInfo, this.request, poLabel);
        return poResource.getPO();
    }

    @POST
    @Path(value="pos")
    @Consumes(value={"application/json"})
    public void addPO(PO po, @Context HttpServletResponse servletResponse) throws Exception {
        log.debug("addPO: invoked");
        if (!FMHolder.get().isOpenForBusiness()) {
            try {
                servletResponse.sendError(503, "Service is unavailable");
            }
            catch (Throwable e) {
                log.error("Error in response " + e);
            }
            return;
        }
        try {
            if (DFHolder.get().posRepo.getRow((Object)po.label) != null) {
                log.debug("addPO: already contains " + po.label);
                servletResponse.sendError(400, "addPO: already contains " + po.label);
            } else {
                if (!po.isValid()) {
                    log.debug("addPO: invalid PO: " + po);
                    servletResponse.sendError(400, "addPO: invalid PO: " + po);
                }
                log.debug("addPO: adding " + po.label);
                DFHolder.get().posRepo.setRow((Object)po.label, po.toRow());
            }
        }
        catch (Throwable e) {
            log.error("Failed to add PO " + po.label);
            try {
                servletResponse.sendError(500, "Failed to add PO " + po.label);
            }
            catch (IOException e1) {
                log.error("Error in response " + e);
            }
        }
    }

    @DELETE
    @Path(value="pos/{po}")
    public void deletePO(@PathParam(value="po") String poLabel, @Context HttpServletResponse servletResponse) {
        log.debug("deletePO: invoked");
        if (!FMHolder.get().isOpenForBusiness()) {
            try {
                servletResponse.sendError(503, "Service is unavailable");
            }
            catch (Throwable e) {
                log.error("Error in response " + e);
            }
            return;
        }
        POResource poResource = new POResource(this.uriInfo, this.request, poLabel);
        poResource.deletePO();
    }

    @GET
    @Path(value="pns")
    @Produces(value={"application/json"})
    public Collection<PN> getPNs(@Context HttpServletResponse servletResponse) {
        log.debug("getPNs: Invoked");
        if (!FMHolder.get().isOpenForBusiness()) {
            try {
                servletResponse.sendError(503, "Service is unavailable");
            }
            catch (Throwable e) {
                log.error("Error in response " + e);
            }
            return null;
        }
        ArrayList<PN> pnList = new ArrayList<PN>();
        try {
            Repo pNsRepo = DFHolder.get().pNsRepo;
            Hashtable res = pNsRepo.getTable();
            if (res == null) {
                return pnList;
            }
            Collection pnResList = res.values();
            Iterator i = pnResList.iterator();
            while (i.hasNext()) {
                pnList.add(new PN((Hashtable)i.next()));
            }
            return pnList;
        }
        catch (Throwable e) {
            log.error("Failed to retrieve pns. ", e);
            return pnList;
        }
    }

    @GET
    @Path(value="pns/count")
    @Produces(value={"application/json"})
    public String getPNsCount(@Context HttpServletResponse servletResponse) {
        log.debug("getPNsCount: invoked");
        if (!FMHolder.get().isOpenForBusiness()) {
            try {
                servletResponse.sendError(503, "Service is unavailable");
            }
            catch (Throwable e) {
                log.error("Error in response " + e);
            }
            return null;
        }
        try {
            Repo pNsRepo = DFHolder.get().pNsRepo;
            int count = pNsRepo.getKeys().size();
            return String.valueOf(count);
        }
        catch (Throwable e) {
            log.error("Failed to retrieve PNs count");
            return null;
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="pns/{pn}")
    public PN getPN(@PathParam(value="pn") String pnLabel, @Context HttpServletResponse servletResponse) {
        log.debug("getPN: invoked");
        if (!FMHolder.get().isOpenForBusiness()) {
            try {
                servletResponse.sendError(503, "Service is unavailable");
            }
            catch (Throwable e) {
                log.error("Error in response " + e);
            }
            return null;
        }
        PNResource pnResource = new PNResource(this.uriInfo, this.request, pnLabel);
        return pnResource.getPN();
    }

    @POST
    @Path(value="pns")
    @Consumes(value={"application/json"})
    public void addPN(PN pn, @Context HttpServletResponse servletResponse) throws Exception {
        log.debug("addPN: invoked");
        if (!FMHolder.get().isOpenForBusiness()) {
            try {
                servletResponse.sendError(503, "Service is unavailable");
            }
            catch (Throwable e) {
                log.error("Error in response " + e);
            }
            return;
        }
        try {
            DFHolder.get().getMgmtPoint().addPN(pn);
        }
        catch (IllegalStateException e1) {
            try {
                servletResponse.sendError(409, "Failed to add PN " + pn.label);
            }
            catch (IOException e2) {
                log.error("Error in response " + e2);
            }
        }
        catch (Throwable e) {
            log.error("Failed to add PN " + pn.label);
            try {
                servletResponse.sendError(500, "Failed to add PN " + pn.label);
            }
            catch (IOException e3) {
                log.error("Error in response " + e3);
            }
        }
    }

    @DELETE
    @Path(value="pns/{pn}")
    public void deletePn(@PathParam(value="pn") String pnLabel, @Context HttpServletResponse servletResponse) {
        log.debug("deletePn: invoked");
        if (!FMHolder.get().isOpenForBusiness()) {
            try {
                servletResponse.sendError(503, "Service is unavailable");
            }
            catch (Throwable e) {
                log.error("Error in response " + e);
            }
            return;
        }
        PNResource pnResource = new PNResource(this.uriInfo, this.request, pnLabel);
        PNResource.PNResourceStatus status = pnResource.deletePN();
        int errorCode = 0;
        switch (status) {
            case OK: {
                errorCode = 0;
                break;
            }
            case CONFLICT: {
                errorCode = 409;
                break;
            }
            case SERVER_ERROR: {
                errorCode = 500;
            }
        }
        if (errorCode != 0) {
            try {
                servletResponse.sendError(errorCode, "Failed to remove PN " + pnLabel);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    @GET
    @Path(value="amss")
    @Produces(value={"application/json"})
    public Collection<AMS> getAMSs(@Context HttpServletResponse servletResponse) {
        log.debug("getAMSs: invoked");
        if (!FMHolder.get().isOpenForBusiness()) {
            try {
                servletResponse.sendError(503, "Service is unavailable");
            }
            catch (Throwable e) {
                log.error("Error in response " + e);
            }
            return null;
        }
        ArrayList<AMS> amsList = new ArrayList<AMS>();
        try {
            Repo amsRepo = DFHolder.get().amsRepo;
            Hashtable res = amsRepo.getTable();
            if (res == null) {
                return amsList;
            }
            Collection amsResList = res.values();
            Iterator i = amsResList.iterator();
            while (i.hasNext()) {
                amsList.add(new AMS((Hashtable)i.next()));
            }
        }
        catch (Throwable e) {
            log.error("Failed to retrieve amss. ", e);
        }
        return amsList;
    }

    @GET
    @Path(value="amss/count")
    @Produces(value={"application/json"})
    public String getDPsCount(@Context HttpServletResponse servletResponse) {
        log.debug("getDPsCount: invoked");
        if (!FMHolder.get().isOpenForBusiness()) {
            try {
                servletResponse.sendError(503, "Service is unavailable");
            }
            catch (Throwable e) {
                log.error("Error in response " + e);
            }
            return null;
        }
        try {
            Repo dPsRepo = DFHolder.get().amsRepo;
            int count = dPsRepo.getKeys().size();
            return String.valueOf(count);
        }
        catch (Throwable e) {
            log.error("Failed to retrieve AMSs count");
            return null;
        }
    }

    @GET
    @Path(value="amss/{ams}")
    @Produces(value={"application/json"})
    public AMS getAMS(@PathParam(value="ams") String amsLabel, @Context HttpServletResponse servletResponse) {
        log.debug("getAMS: invoked");
        if (!FMHolder.get().isOpenForBusiness()) {
            try {
                servletResponse.sendError(503, "Service is unavailable");
            }
            catch (Throwable e) {
                log.error("Error in response " + e);
            }
            return null;
        }
        try {
            AmsResource amsResource = new AmsResource(this.uriInfo, this.request, amsLabel);
            return amsResource.getAms();
        }
        catch (Throwable e) {
            return new AMS();
        }
    }

    @POST
    @Path(value="amss")
    @Consumes(value={"application/json"})
    public void addAMS(AMS ams, @Context HttpServletResponse servletResponse) {
        log.debug("addAMS: invoked");
        if (!FMHolder.get().isOpenForBusiness()) {
            try {
                servletResponse.sendError(503, "Service is unavailable");
            }
            catch (Throwable e) {
                log.error("Error in response " + e);
            }
            return;
        }
        try {
            DFHolder.get().getMgmtPoint().addAMS(ams);
        }
        catch (IllegalStateException e1) {
            try {
                servletResponse.sendError(409, "Failed to add AMS " + ams.label);
            }
            catch (IOException e2) {
                log.error("Error in response " + e2);
            }
        }
        catch (Throwable e) {
            log.error("Failed to add AMS " + ams.label);
            try {
                servletResponse.sendError(500, "Failed to add AMS " + ams.label);
            }
            catch (IOException e3) {
                log.error("Error in response " + e3);
            }
        }
    }

    @DELETE
    @Path(value="amss/{ams}")
    public void deleteAms(@PathParam(value="ams") String amsLabel, @Context HttpServletResponse servletResponse) {
        log.debug("deleteAms: invoked");
        if (!FMHolder.get().isOpenForBusiness()) {
            try {
                servletResponse.sendError(503, "Service is unavailable");
            }
            catch (Throwable e) {
                log.error("Error in response " + e);
            }
            return;
        }
        AmsResource amsResource = new AmsResource(this.uriInfo, this.request, amsLabel);
        AmsResource.AMSResourceStatus status = amsResource.deleteAms();
        int errorCode = 0;
        switch (status) {
            case OK: {
                errorCode = 0;
                break;
            }
            case CONFLICT: {
                errorCode = 409;
                break;
            }
            case SERVER_ERROR: {
                errorCode = 500;
            }
        }
        if (errorCode != 0) {
            try {
                servletResponse.sendError(errorCode, "Failed to remove AMS " + amsLabel);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    @GET
    @Path(value="ofcs")
    @Produces(value={"application/json"})
    public Collection<OFC> getOFCs(@Context HttpServletResponse servletResponse) {
        log.debug("getOFCs: invoked");
        if (!FMHolder.get().isOpenForBusiness()) {
            try {
                servletResponse.sendError(503, "Service is unavailable");
            }
            catch (Throwable e) {
                log.error("Error in response " + e);
            }
            return null;
        }
        ArrayList<OFC> ofcList = new ArrayList<OFC>();
        try {
            Repo oFCsRepo = DFHolder.get().oFCsRepo;
            Hashtable res = oFCsRepo.getTable();
            if (res == null) {
                return ofcList;
            }
            Collection ofcResList = res.values();
            Iterator i = ofcResList.iterator();
            while (i.hasNext()) {
                ofcList.add(new OFC((Hashtable)i.next()));
            }
        }
        catch (Throwable e) {
            log.error("Failed to retrieve ofcs. ", e);
            return null;
        }
        return ofcList;
    }

    @GET
    @Path(value="ofcs/count")
    @Produces(value={"application/json"})
    public String getOFCsCount(@Context HttpServletResponse servletResponse) {
        log.debug("getOFCsCount: invoked");
        if (!FMHolder.get().isOpenForBusiness()) {
            try {
                servletResponse.sendError(503, "Service is unavailable");
            }
            catch (Throwable e) {
                log.error("Error in response " + e);
            }
            return null;
        }
        try {
            log.debug("getOFCsCount: invoked");
            Repo oFCsRepo = DFHolder.get().oFCsRepo;
            int count = oFCsRepo.getKeys().size();
            return String.valueOf(count);
        }
        catch (Throwable e) {
            log.error("Failed to retrieve OFCs count");
            return null;
        }
    }

    @GET
    @Path(value="ofcs/{ofc}")
    @Produces(value={"application/json"})
    public OFC getOFC(@PathParam(value="ofc") String ofcLabel, @Context HttpServletResponse servletResponse) {
        log.debug("getOFC : " + ofcLabel);
        if (!FMHolder.get().isOpenForBusiness()) {
            try {
                servletResponse.sendError(503, "Service is unavailable");
            }
            catch (Throwable e) {
                log.error("Error in response " + e);
            }
            return null;
        }
        try {
            OFCResource ofcResource = new OFCResource(this.uriInfo, this.request, ofcLabel);
            return ofcResource.getOFC();
        }
        catch (Throwable e) {
            return new OFC();
        }
    }

    @POST
    @Path(value="ofcs")
    @Consumes(value={"application/json"})
    public void addOFC(OFC ofc, @Context HttpServletResponse servletResponse) {
        log.debug("addOFC : invoked ");
        if (!FMHolder.get().isOpenForBusiness()) {
            try {
                servletResponse.sendError(503, "Service is unavailable");
            }
            catch (Throwable e) {
                log.error("Error in response " + e);
            }
            return;
        }
        try {
            Repo oFCsRepo = DFHolder.get().oFCsRepo;
            if (oFCsRepo.getRow((Object)ofc.hostname) != null) {
                log.debug("addOFC: already contains " + ofc.hostname);
                servletResponse.sendError(400, "addOFC: already contains " + ofc.hostname);
            } else {
                log.debug("addOFC: adding " + ofc.hostname);
                DFHolder.get().getMgmtPoint().addOFC(ofc);
            }
        }
        catch (Throwable e) {
            try {
                DFHolder.get().getMgmtPoint().removeOFC(ofc.getHostname());
            }
            catch (Exception e2) {
                log.warn("caught an exception when trying to remove OFC leftovers after add OFC failed", (Throwable)e2);
            }
            log.error("Failed to add OFC " + ofc.hostname);
            try {
                servletResponse.sendError(500, "Failed to add OFC " + ofc.hostname);
            }
            catch (IOException e1) {
                log.error("Error in response " + e1);
            }
        }
    }

    @DELETE
    @Path(value="ofcs/{ofc}")
    public void deleteOfc(@PathParam(value="ofc") String ofcLabel, @Context HttpServletResponse servletResponse) {
        log.debug("deleteOfc : invoked ");
        if (!FMHolder.get().isOpenForBusiness()) {
            try {
                servletResponse.sendError(503, "Service is unavailable");
            }
            catch (Throwable e) {
                log.error("Error in response " + e);
            }
            return;
        }
        try {
            if (!FMHolder.get().isOpenForBusiness()) {
                servletResponse.sendError(503, "Service is unavailable");
            }
        }
        catch (Throwable e) {
            log.error("Error in response " + e);
            return;
        }
        OFCResource ofcResource = new OFCResource(this.uriInfo, this.request, ofcLabel);
        ofcResource.deleteOFC();
    }

    @GET
    @Path(value="netnodes")
    @Produces(value={"application/json"})
    public ArrayList<NetNode> getNetnodes(@Context HttpServletResponse servletResponse) {
        Collection netNodeResList;
        log.debug("getNetnode: Invoked");
        if (!FMHolder.get().isOpenForBusiness()) {
            try {
                servletResponse.sendError(503, "Service is unavailable");
            }
            catch (Throwable e) {
                log.error("Error in response " + e);
            }
            return null;
        }
        ArrayList<NetNode> netNodeList = new ArrayList<NetNode>();
        try {
            Repo netNodesRepo = DFHolder.get().netNodesRepo;
            Hashtable res = netNodesRepo.getTable();
            if (res == null) {
                return netNodeList;
            }
            netNodeResList = res.values();
        }
        catch (Throwable e) {
            log.error("Failed to retrieve netnodes. ", e);
            return null;
        }
        Hashtable netNodeRow = null;
        Iterator i = netNodeResList.iterator();
        while (i.hasNext()) {
            try {
                netNodeRow = (Hashtable)i.next();
                NetNode netNode = new NetNode(netNodeRow);
                netNode.toJacksonFriendly();
                netNodeList.add(netNode);
                log.debug("NetNode retrieved " + netNodeRow.toString());
            }
            catch (Throwable e) {
                log.error("Failed to retrieve netnode. " + netNodeRow.toString());
            }
        }
        return netNodeList;
    }

    @GET
    @Path(value="netnodes/count")
    @Produces(value={"application/json"})
    public String getNetnodesCount(@Context HttpServletResponse servletResponse) {
        log.debug("getNetnodesCount: Invoked");
        if (!FMHolder.get().isOpenForBusiness()) {
            try {
                servletResponse.sendError(503, "Service is unavailable");
            }
            catch (Throwable e) {
                log.error("Error in response " + e);
            }
            return null;
        }
        try {
            Repo netNodesRepo = DFHolder.get().netNodesRepo;
            int count = netNodesRepo.getKeys().size();
            return String.valueOf(count);
        }
        catch (Throwable e) {
            log.error("Failed to retrieve OFCs count");
            return null;
        }
    }

    @GET
    @Path(value="netnodes/{netnode}")
    @Produces(value={"application/json"})
    public NetNode getNetNode(@PathParam(value="netnode") String netNodeLabel, @Context HttpServletResponse servletResponse) {
        log.debug("getNetNode: Invoked");
        if (!FMHolder.get().isOpenForBusiness()) {
            try {
                servletResponse.sendError(503, "Service is unavailable");
            }
            catch (Throwable e) {
                log.error("Error in response " + e);
            }
            return null;
        }
        try {
            NetNodeResource netNodeResource = new NetNodeResource(this.uriInfo, this.request, netNodeLabel);
            return netNodeResource.getNetNode();
        }
        catch (Throwable e) {
            return new NetNode();
        }
    }

    @POST
    @Path(value="netnodes")
    @Consumes(value={"application/json"})
    public void addNetNode(NetNode netNode, @Context HttpServletResponse servletResponse) throws Exception {
        log.debug("addNetNode: Invoked");
        if (!FMHolder.get().isOpenForBusiness()) {
            try {
                servletResponse.sendError(503, "Service is unavailable");
            }
            catch (Throwable e) {
                log.error("Error in response " + e);
            }
            return;
        }
        int errorCode = 0;
        try {
            DFHolder.get().getMgmtPoint().addNetNode(netNode);
            errorCode = 0;
        }
        catch (NotSupportedException e1) {
            errorCode = 405;
        }
        catch (Throwable e) {
            log.error("Failed to add NetNode " + netNode.label);
            errorCode = 500;
        }
        if (errorCode != 0) {
            try {
                servletResponse.sendError(errorCode, "Failed to add NetNode " + netNode.label);
            }
            catch (IOException e1) {
                log.error("Error in response " + e1);
            }
        }
    }

    @DELETE
    @Path(value="netnodes/{netnode}")
    public void deleteNetNode(@PathParam(value="netnode") String netNodeLabel, @Context HttpServletResponse servletResponse) {
        log.debug("deleteNetNode: Invoked");
        if (!FMHolder.get().isOpenForBusiness()) {
            try {
                servletResponse.sendError(503, "Service is unavailable");
            }
            catch (Throwable e) {
                log.error("Error in response " + e);
            }
            return;
        }
        NetNodeResource netNodeResource = new NetNodeResource(this.uriInfo, this.request, netNodeLabel);
        NetNodeResource.NetNodeResourceStatus status = netNodeResource.deleteNetNode();
        int errorCode = 0;
        switch (status) {
            case OK: {
                errorCode = 0;
                break;
            }
            case FORBIDDEN: {
                errorCode = 405;
                break;
            }
            case CONFLICT: {
                errorCode = 409;
                break;
            }
            case SERVER_ERROR: {
                errorCode = 500;
            }
        }
        if (errorCode != 0) {
            try {
                servletResponse.sendError(errorCode, "Failed to remove PN " + netNodeLabel);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    @GET
    @Path(value="mitigations")
    @Produces(value={"application/json"})
    public Collection<Mitigation> getMitigations(@Context HttpServletResponse servletResponse) {
        log.debug("getMitigations: Invoked");
        if (!FMHolder.get().isOpenForBusiness()) {
            try {
                servletResponse.sendError(503, "Service is unavailable");
            }
            catch (Throwable e) {
                log.error("Error in response " + e);
            }
            return null;
        }
        ArrayList<Mitigation> mitigationsList = new ArrayList<Mitigation>();
        try {
            Repo mitigationsRepo = DFHolder.get().mitigationsRepo;
            Hashtable res = mitigationsRepo.getTable();
            if (res == null) {
                return mitigationsList;
            }
            Collection mitigationsResList = res.values();
            Iterator i = mitigationsResList.iterator();
            while (i.hasNext()) {
                mitigationsList.add(new Mitigation((Hashtable)i.next()));
            }
        }
        catch (Throwable e) {
            log.error("Failed to retrieve mitigations. ", e);
            return null;
        }
        return mitigationsList;
    }

    @GET
    @Path(value="mitigations/{mitigation}")
    @Produces(value={"application/json"})
    public Mitigation getMitigation(@PathParam(value="mitigation") String mitigationLabel, @Context HttpServletResponse servletResponse) {
        log.debug("getMitigation: Invoked");
        if (!FMHolder.get().isOpenForBusiness()) {
            try {
                servletResponse.sendError(503, "Service is unavailable");
            }
            catch (Throwable e) {
                log.error("Error in response " + e);
            }
            return null;
        }
        try {
            Repo mitigationsRepo = DFHolder.get().mitigationsRepo;
            Hashtable mitigationRow = mitigationsRepo.getRow((Object)mitigationLabel);
            Mitigation mitigation = new Mitigation(mitigationRow);
            return mitigation;
        }
        catch (Throwable e) {
            log.error("Failed to retrieve mitigation " + mitigationLabel, e);
            return null;
        }
    }

    @GET
    @Path(value="attacks")
    @Produces(value={"application/json"})
    public Collection<Attack> getAttacks(@Context HttpServletResponse servletResponse) {
        log.debug("getAttacks: Invoked");
        if (!FMHolder.get().isOpenForBusiness()) {
            try {
                servletResponse.sendError(503, "Service is unavailable");
            }
            catch (Throwable e) {
                log.error("Error in response " + e);
            }
            return null;
        }
        ArrayList<Attack> attackList = new ArrayList<Attack>();
        try {
            log.debug("getAttacks: Invoked");
            Repo attacksRepo = DFHolder.get().attacksRepo;
            Hashtable res = attacksRepo.getTable();
            if (res == null) {
                return attackList;
            }
            Collection attackResList = res.values();
            Iterator i = attackResList.iterator();
            while (i.hasNext()) {
                attackList.add(new Attack((Hashtable)i.next()));
            }
        }
        catch (Throwable e) {
            log.error("Failed to retrieve attacks. ", e);
            return null;
        }
        return attackList;
    }

    @GET
    @Path(value="attacks/{attack}")
    @Produces(value={"application/json"})
    public Attack getAttack(@PathParam(value="attack") String attackLabel, @Context HttpServletResponse servletResponse) {
        log.debug("getAttack: Invoked");
        if (!FMHolder.get().isOpenForBusiness()) {
            try {
                servletResponse.sendError(503, "Service is unavailable");
            }
            catch (Throwable e) {
                log.error("Error in response " + e);
            }
            return null;
        }
        try {
            Repo attacksRepo = DFHolder.get().attacksRepo;
            Hashtable attackRow = attacksRepo.getRow((Object)attackLabel);
            Attack attack = new Attack(attackRow);
            return attack;
        }
        catch (Throwable e) {
            log.error("Failed to retrieve attack " + attackLabel, e);
            return null;
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="pnstats")
    public Collection<PNStatReport> getPNStats(@Context HttpServletResponse servletResponse) {
        log.debug("getPNStats: Invoked");
        if (!FMHolder.get().isOpenForBusiness()) {
            try {
                servletResponse.sendError(503, "Service is unavailable");
            }
            catch (Throwable e) {
                log.error("Error in response " + e);
            }
            return null;
        }
        try {
            Collection pnStatReports = DFHolder.get().getMgmtPoint().getLatestPNStatReports();
            return pnStatReports;
        }
        catch (Throwable e) {
            log.error("Failed to retrieve pnStats. ", e);
            return null;
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="pnstats/{pn}")
    public PNStatReport getPNStat(@PathParam(value="pn") String pnLabel, @Context HttpServletResponse servletResponse) {
        log.debug("getPNStat: Invoked");
        if (!FMHolder.get().isOpenForBusiness()) {
            try {
                servletResponse.sendError(503, "Service is unavailable");
            }
            catch (Throwable e) {
                log.error("Error in response " + e);
            }
            return null;
        }
        try {
            PNStatReport pnStatReport = DFHolder.get().getMgmtPoint().getLatestPNStatReport(pnLabel);
            return pnStatReport;
        }
        catch (IllegalArgumentException e) {
            try {
                servletResponse.sendError(400, "get pnstat: Null or empty pnLabel.");
            }
            catch (IOException e1) {
                log.error("Error in response " + e1);
            }
        }
        catch (Throwable e1) {
            try {
                servletResponse.sendError(500, "Failed to get pnstat for pn " + pnLabel);
            }
            catch (IOException e2) {
                log.error("Error in response " + e2);
            }
        }
        return null;
    }

    @POST
    @Path(value="detectors/{label}")
    @Consumes(value={"application/json"})
    public void changeDetector(Map<String, String> input, @PathParam(value="label") String detectorLabel, @Context HttpServletResponse servletResponse) {
        log.debug("detectors: Invoked");
        if (!FMHolder.get().isOpenForBusiness()) {
            try {
                servletResponse.sendError(503, "Service is unavailable");
            }
            catch (Throwable e) {
                log.error("Error in response " + e);
            }
            return;
        }
        if (detectorLabel == null || DFHolder.get().getDetectorMgr().getDetector(detectorLabel) == null) {
            try {
                servletResponse.sendError(503, "Service is unavailable");
            }
            catch (Throwable e) {
                log.error("Error in response " + e);
            }
            return;
        }
        try {
            for (Map.Entry<String, String> entry : input.entrySet()) {
                String attrName = entry.getKey();
                String attrValue = entry.getValue();
                DFHolder.get().getDetectorMgr().setDetectorProperties(detectorLabel, attrName, attrValue);
            }
        }
        catch (Throwable e) {
            try {
                servletResponse.sendError(500, "Failed to update detector " + detectorLabel);
            }
            catch (IOException e2) {
                log.error("Error in response " + e2);
            }
        }
    }
}

