/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.defense4all.restservice;

import java.net.URI;
import java.util.Hashtable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opendaylight.defense4all.core.DFHolder;
import org.opendaylight.defense4all.core.PN;
import org.opendaylight.defense4all.framework.core.ExceptionControlApp;
import org.opendaylight.defense4all.framework.core.Repo;

public class PNResource {
    private static Log log = LogFactory.getLog(PNResource.class);
    @Context
    UriInfo uriInfo;
    @Context
    Request request;
    String pnLabel;

    public PNResource(UriInfo uriInfo, Request request, String pnLabel) {
        this.uriInfo = uriInfo;
        this.request = request;
        this.pnLabel = pnLabel;
    }

    @GET
    @Produces(value={"application/json"})
    public PN getPN() {
        try {
            log.debug((Object)("In getPN. PN label is " + this.pnLabel));
            Repo pNsRepo = DFHolder.get().pNsRepo;
            Hashtable pnRow = pNsRepo.getRow((Object)this.pnLabel);
            if (pnRow == null) {
                return null;
            }
            return new PN(pnRow);
        }
        catch (ExceptionControlApp e) {
            log.error((Object)("Failed to retrieve pn " + this.pnLabel), (Throwable)e);
            return null;
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response putPN(JAXBElement<PN> jaxbPN) {
        try {
            Response res;
            PN pn = (PN)jaxbPN.getValue();
            Repo pNsRepo = DFHolder.get().pNsRepo;
            if (pNsRepo.getRow((Object)this.pnLabel) != null) {
                res = Response.noContent().build();
            } else {
                res = Response.created((URI)this.uriInfo.getAbsolutePath()).build();
                DFHolder.get().getMgmtPoint().changePN(pn);
            }
            return res;
        }
        catch (ExceptionControlApp e) {
            log.error((Object)("Failed to retrieve pn " + this.pnLabel), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @DELETE
    public PNResourceStatus deletePN() {
        try {
            log.debug((Object)"DeletePN: invoked");
            boolean success = DFHolder.get().getMgmtPoint().removePN(this.pnLabel);
            return success ? PNResourceStatus.OK : PNResourceStatus.CONFLICT;
        }
        catch (ExceptionControlApp e) {
            log.error((Object)("Failed to delete pn " + this.pnLabel), (Throwable)e);
            return PNResourceStatus.SERVER_ERROR;
        }
    }

    public static enum PNResourceStatus {
        OK,
        CONFLICT,
        SERVER_ERROR;

    }
}

