/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.topology.northbound;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.opendaylight.controller.sal.core.Edge;
import org.opendaylight.controller.sal.core.Property;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class EdgeProperties {
    @XmlElement
    private Edge edge;
    @XmlElement(name="property")
    @XmlElementWrapper
    @JsonIgnore
    private Set<Property> properties;

    private EdgeProperties() {
        this.edge = null;
        this.properties = null;
    }

    public EdgeProperties(Edge e, Set<Property> properties) {
        this.edge = e;
        this.properties = properties;
    }

    @JsonProperty(value="properties")
    public Map<String, Property> getMapProperties() {
        HashMap<String, Property> map = new HashMap<String, Property>();
        for (Property p : this.properties) {
            map.put(p.getName(), p);
        }
        return map;
    }

    public void setMapProperties(Map<String, Property> propertiesMap) {
        this.properties = new HashSet<Property>(propertiesMap.values());
    }

    public Set<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(Set<Property> properties) {
        this.properties = properties;
    }

    public Edge getEdge() {
        return this.edge;
    }

    public void setEdge(Edge edge) {
        this.edge = edge;
    }
}

