/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.subnets.northbound;

import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.codehaus.enunciate.jaxrs.TypeHint;
import org.opendaylight.controller.containermanager.IContainerManager;
import org.opendaylight.controller.northbound.commons.RestMessages;
import org.opendaylight.controller.northbound.commons.exception.BadRequestException;
import org.opendaylight.controller.northbound.commons.exception.ResourceConflictException;
import org.opendaylight.controller.northbound.commons.exception.ResourceNotFoundException;
import org.opendaylight.controller.northbound.commons.exception.ServiceUnavailableException;
import org.opendaylight.controller.northbound.commons.exception.UnauthorizedException;
import org.opendaylight.controller.northbound.commons.query.QueryContext;
import org.opendaylight.controller.northbound.commons.utils.NorthboundUtils;
import org.opendaylight.controller.sal.authorization.Privilege;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.utils.ServiceHelper;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.subnets.northbound.SubnetConfigs;
import org.opendaylight.controller.switchmanager.ISwitchManager;
import org.opendaylight.controller.switchmanager.SubnetConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class SubnetsNorthbound {
    protected static final Logger logger = LoggerFactory.getLogger(SubnetsNorthbound.class);
    private String username;
    private QueryContext queryContext;

    @Context
    public void setQueryContext(ContextResolver<QueryContext> queryCtxResolver) {
        if (queryCtxResolver != null) {
            this.queryContext = (QueryContext)queryCtxResolver.getContext(QueryContext.class);
        }
    }

    @Context
    public void setSecurityContext(SecurityContext context) {
        if (context != null && context.getUserPrincipal() != null) {
            this.username = context.getUserPrincipal().getName();
        }
    }

    protected String getUserName() {
        return this.username;
    }

    private void handleContainerDoesNotExist(String containerName) {
        IContainerManager containerManager = (IContainerManager)ServiceHelper.getGlobalInstance(IContainerManager.class, (Object)this);
        if (containerManager == null) {
            throw new ServiceUnavailableException("Container " + RestMessages.NOCONTAINER.toString());
        }
        List containerNames = containerManager.getContainerNames();
        for (String cName : containerNames) {
            if (!cName.trim().equalsIgnoreCase(containerName.trim())) continue;
            return;
        }
        throw new ResourceNotFoundException(containerName + " " + RestMessages.NOCONTAINER.toString());
    }

    private void handleNameMismatch(String name, String nameinURL) {
        if (name == null || nameinURL == null) {
            throw new BadRequestException(RestMessages.INVALIDDATA.toString() + " : Name is null");
        }
        if (name.equals(nameinURL)) {
            return;
        }
        throw new ResourceConflictException(RestMessages.INVALIDDATA.toString() + " : Name in URL does not match the name in request body");
    }

    @Path(value="/{containerName}/subnets")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @StatusCodes(value={@ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=404, condition="The containerName passed was not found"), @ResponseCode(code=503, condition="Service unavailable"), @ResponseCode(code=400, condition="Incorrect query syntex")})
    @TypeHint(value=SubnetConfigs.class)
    public SubnetConfigs listSubnets(@PathParam(value="containerName") String containerName, @QueryParam(value="_q") String queryString) {
        this.handleContainerDoesNotExist(containerName);
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.READ, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        ISwitchManager switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)this);
        if (switchManager == null) {
            throw new ServiceUnavailableException("SwitchManager " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        List subnets = switchManager.getSubnetsConfigList();
        if (queryString != null) {
            subnets = this.queryContext.createQuery(queryString, SubnetConfig.class).find((Collection)subnets);
        }
        return new SubnetConfigs(subnets);
    }

    @Path(value="/{containerName}/subnet/{subnetName}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @StatusCodes(value={@ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=404, condition="The containerName or subnetName passed was not found"), @ResponseCode(code=503, condition="Service unavailable")})
    @TypeHint(value=SubnetConfig.class)
    public SubnetConfig listSubnet(@PathParam(value="containerName") String containerName, @PathParam(value="subnetName") String subnetName) {
        this.handleContainerDoesNotExist(containerName);
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.READ, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        ISwitchManager switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)this);
        if (switchManager == null) {
            throw new ServiceUnavailableException("SwitchManager " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        SubnetConfig res = switchManager.getSubnetConfig(subnetName);
        if (res == null) {
            throw new ResourceNotFoundException(RestMessages.NOSUBNET.toString());
        }
        return res;
    }

    @Path(value="/{containerName}/subnet/{subnetName}")
    @PUT
    @StatusCodes(value={@ResponseCode(code=201, condition="Subnet created successfully"), @ResponseCode(code=400, condition="Invalid data passed"), @ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=409, condition="Subnet name in url conflicts with name in request body"), @ResponseCode(code=404, condition="Container name passed was not found or subnet config is null"), @ResponseCode(code=500, condition="Internal Server Error: Addition of subnet failed"), @ResponseCode(code=503, condition="Service unavailable")})
    public Response addSubnet(@PathParam(value="containerName") String containerName, @PathParam(value="subnetName") String subnetName, @TypeHint(value=SubnetConfig.class) SubnetConfig subnetConfigData) {
        this.handleContainerDoesNotExist(containerName);
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.WRITE, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        SubnetConfig cfgObject = subnetConfigData;
        this.handleNameMismatch(cfgObject.getName(), subnetName);
        ISwitchManager switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)this);
        if (switchManager == null) {
            throw new ServiceUnavailableException("SwitchManager " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        Status status = switchManager.addSubnet(cfgObject);
        if (status.isSuccess()) {
            NorthboundUtils.auditlog((String)"Subnet Gateway", (String)this.username, (String)"added", (String)subnetName, (String)containerName);
            if (subnetConfigData.getNodeConnectors() != null) {
                for (NodeConnector port : subnetConfigData.getNodeConnectors()) {
                    NorthboundUtils.auditlog((String)"Port", (String)this.getUserName(), (String)"added", (String)(NorthboundUtils.getPortName((NodeConnector)port, (ISwitchManager)switchManager) + " to Subnet Gateway " + subnetName), (String)containerName);
                }
            }
            return Response.status((Response.Status)Response.Status.CREATED).build();
        }
        return NorthboundUtils.getResponse((Status)status);
    }

    @Path(value="/{containerName}/subnet/{subnetName}")
    @DELETE
    @StatusCodes(value={@ResponseCode(code=204, condition="No Content"), @ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=404, condition="The containerName passed was not found"), @ResponseCode(code=500, condition="Internal Server Error : Removal of subnet failed"), @ResponseCode(code=503, condition="Service unavailable")})
    public Response removeSubnet(@PathParam(value="containerName") String containerName, @PathParam(value="subnetName") String subnetName) {
        this.handleContainerDoesNotExist(containerName);
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.WRITE, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        ISwitchManager switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)this);
        if (switchManager == null) {
            throw new ServiceUnavailableException("SwitchManager " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        Status status = switchManager.removeSubnet(subnetName);
        if (status.isSuccess()) {
            NorthboundUtils.auditlog((String)"Subnet Gateway", (String)this.username, (String)"removed", (String)subnetName, (String)containerName);
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        return NorthboundUtils.getResponse((Status)status);
    }

    @Path(value="/{containerName}/subnet/{subnetName}")
    @POST
    @Consumes(value={"application/json", "application/xml"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Configuration replaced successfully"), @ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=409, condition="Subnet name in url conflicts with name in request body"), @ResponseCode(code=404, condition="The containerName or subnetName is not found"), @ResponseCode(code=500, condition="Internal server error: Modify subnet failed"), @ResponseCode(code=503, condition="Service unavailable")})
    public Response modifySubnet(@Context UriInfo uriInfo, @PathParam(value="containerName") String containerName, @PathParam(value="subnetName") String subnetName, @TypeHint(value=SubnetConfig.class) SubnetConfig subnetConfigData) {
        this.handleContainerDoesNotExist(containerName);
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.WRITE, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        this.handleNameMismatch(subnetConfigData.getName(), subnetName);
        ISwitchManager switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)this);
        if (switchManager == null) {
            throw new ServiceUnavailableException("SwitchManager " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        SubnetConfig existingConf = switchManager.getSubnetConfig(subnetName);
        Status status = switchManager.modifySubnet(subnetConfigData);
        if (status.isSuccess()) {
            if (existingConf == null) {
                NorthboundUtils.auditlog((String)"Subnet Gateway", (String)this.username, (String)"added", (String)subnetName, (String)containerName);
                if (subnetConfigData.getNodeConnectors() != null) {
                    for (NodeConnector port : subnetConfigData.getNodeConnectors()) {
                        NorthboundUtils.auditlog((String)"Port", (String)this.getUserName(), (String)"added", (String)(NorthboundUtils.getPortName((NodeConnector)port, (ISwitchManager)switchManager) + " to Subnet Gateway" + subnetName), (String)containerName);
                    }
                }
                return Response.created((URI)uriInfo.getRequestUri()).build();
            }
            HashSet existingNCList = existingConf.getNodeConnectors();
            if (existingNCList == null) {
                existingNCList = new HashSet(0);
            }
            if (subnetConfigData.getNodeConnectors() != null) {
                for (NodeConnector port : subnetConfigData.getNodeConnectors()) {
                    if (existingNCList.contains(port)) continue;
                    NorthboundUtils.auditlog((String)"Port", (String)this.getUserName(), (String)"added", (String)(NorthboundUtils.getPortName((NodeConnector)port, (ISwitchManager)switchManager) + " to Subnet Gateway " + subnetName), (String)containerName);
                }
            }
            for (NodeConnector port : existingNCList) {
                if (subnetConfigData.getNodeConnectors().contains(port)) continue;
                NorthboundUtils.auditlog((String)"Port", (String)this.getUserName(), (String)"removed", (String)(NorthboundUtils.getPortName((NodeConnector)port, (ISwitchManager)switchManager) + " from Subnet Gateway " + subnetName), (String)containerName);
            }
        }
        return NorthboundUtils.getResponse((Status)status);
    }
}

