package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.shutdown.impl.rev131218;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.rpc.context.rev130617.RpcContextRef;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>shutdown-impl</b>
 * <br>(Source path: <i>META-INF/yang/shutdown-impl.yang</i>):
 * <pre>
 * container input {
 *     leaf context-instance {
 *         type instance-identifier;
 *     }
 *     leaf input-secret {
 *         type string;
 *     }
 *     leaf max-wait-time {
 *         type uint32;
 *     }
 *     leaf reason {
 *         type string;
 *     }
 *     uses rpc-context-ref {
 *         refine (urn:opendaylight:params:xml:ns:yang:controller:shutdown:impl?revision=2013-12-18)context-instance {
 *             leaf context-instance {
 *                 type instance-identifier;
 *             }
 *         }
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>shutdown-impl/shutdown/input</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.shutdown.impl.rev131218.ShutdownInputBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.shutdown.impl.rev131218.ShutdownInputBuilder
 *
 */
public interface ShutdownInput
    extends
    RpcContextRef,
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.shutdown.impl.rev131218.ShutdownInput>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:shutdown:impl",
        "2013-12-18", "input").intern();

    java.lang.String getInputSecret();
    
    /**
     * Maximum time in milliseconds before process is forcibly exited. Zero or null 
     * cancels this functionality.
     *
     */
    java.lang.Long getMaxWaitTime();
    
    java.lang.String getReason();

}

