package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.shutdown.impl.rev131218;
import java.util.concurrent.Future;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;


/**
 * Interface for implementing the following YANG RPCs defined in module <b>shutdown-impl</b>
 * <br>(Source path: <i>META-INF/yang/shutdown-impl.yang</i>):
 * <pre>
 * rpc shutdown {
 *     input {
 *         leaf context-instance {
 *             type instance-identifier;
 *         }
 *         leaf input-secret {
 *             type string;
 *         }
 *         leaf max-wait-time {
 *             type uint32;
 *         }
 *         leaf reason {
 *             type string;
 *         }
 *     }
 *     
 * }
 * </pre>
 *
 */
public interface ShutdownImplService
    extends
    RpcService
{




    Future<RpcResult<java.lang.Void>> shutdown(ShutdownInput input);

}

