/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.shutdown.impl.rev131218;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.rpc.context.rev130617.RpcContextRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.shutdown.impl.rev131218.ShutdownInput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public class ShutdownInputBuilder
implements Builder<ShutdownInput> {
    private InstanceIdentifier<?> _contextInstance;
    private String _inputSecret;
    private Long _maxWaitTime;
    private String _reason;
    Map<Class<? extends Augmentation<ShutdownInput>>, Augmentation<ShutdownInput>> augmentation = Collections.emptyMap();

    public ShutdownInputBuilder() {
    }

    public ShutdownInputBuilder(RpcContextRef arg) {
        this._contextInstance = arg.getContextInstance();
    }

    public ShutdownInputBuilder(ShutdownInput base) {
        AugmentationHolder casted;
        this._contextInstance = base.getContextInstance();
        this._inputSecret = base.getInputSecret();
        this._maxWaitTime = base.getMaxWaitTime();
        this._reason = base.getReason();
        if (base instanceof ShutdownInputImpl) {
            ShutdownInputImpl impl = (ShutdownInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ShutdownInput>>, Augmentation<ShutdownInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ShutdownInput>>, Augmentation<ShutdownInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof RpcContextRef) {
            this._contextInstance = ((RpcContextRef)arg).getContextInstance();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.rpc.context.rev130617.RpcContextRef] \nbut was: " + arg);
        }
    }

    public InstanceIdentifier<?> getContextInstance() {
        return this._contextInstance;
    }

    public String getInputSecret() {
        return this._inputSecret;
    }

    public Long getMaxWaitTime() {
        return this._maxWaitTime;
    }

    public String getReason() {
        return this._reason;
    }

    public <E extends Augmentation<ShutdownInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ShutdownInputBuilder setContextInstance(InstanceIdentifier<?> value) {
        this._contextInstance = value;
        return this;
    }

    public ShutdownInputBuilder setInputSecret(String value) {
        this._inputSecret = value;
        return this;
    }

    private static void checkMaxWaitTimeRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public ShutdownInputBuilder setMaxWaitTime(Long value) {
        if (value != null) {
            ShutdownInputBuilder.checkMaxWaitTimeRange(value);
        }
        this._maxWaitTime = value;
        return this;
    }

    public ShutdownInputBuilder setReason(String value) {
        this._reason = value;
        return this;
    }

    public ShutdownInputBuilder addAugmentation(Class<? extends Augmentation<ShutdownInput>> augmentationType, Augmentation<ShutdownInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ShutdownInput>>, Augmentation<ShutdownInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ShutdownInputBuilder removeAugmentation(Class<? extends Augmentation<ShutdownInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ShutdownInput build() {
        return new ShutdownInputImpl(this);
    }

    private static final class ShutdownInputImpl
    implements ShutdownInput {
        private final InstanceIdentifier<?> _contextInstance;
        private final String _inputSecret;
        private final Long _maxWaitTime;
        private final String _reason;
        private Map<Class<? extends Augmentation<ShutdownInput>>, Augmentation<ShutdownInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ShutdownInput> getImplementedInterface() {
            return ShutdownInput.class;
        }

        private ShutdownInputImpl(ShutdownInputBuilder base) {
            this._contextInstance = base.getContextInstance();
            this._inputSecret = base.getInputSecret();
            this._maxWaitTime = base.getMaxWaitTime();
            this._reason = base.getReason();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ShutdownInput>>, Augmentation<ShutdownInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ShutdownInput>>, Augmentation<ShutdownInput>>(base.augmentation);
                }
            }
        }

        public InstanceIdentifier<?> getContextInstance() {
            return this._contextInstance;
        }

        @Override
        public String getInputSecret() {
            return this._inputSecret;
        }

        @Override
        public Long getMaxWaitTime() {
            return this._maxWaitTime;
        }

        @Override
        public String getReason() {
            return this._reason;
        }

        public <E extends Augmentation<ShutdownInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._contextInstance);
            result = 31 * result + Objects.hashCode(this._inputSecret);
            result = 31 * result + Objects.hashCode(this._maxWaitTime);
            result = 31 * result + Objects.hashCode(this._reason);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ShutdownInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ShutdownInput other = (ShutdownInput)obj;
            if (!Objects.equals(this._contextInstance, other.getContextInstance())) {
                return false;
            }
            if (!Objects.equals(this._inputSecret, other.getInputSecret())) {
                return false;
            }
            if (!Objects.equals(this._maxWaitTime, other.getMaxWaitTime())) {
                return false;
            }
            if (!Objects.equals(this._reason, other.getReason())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ShutdownInputImpl otherImpl = (ShutdownInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ShutdownInput>>, Augmentation<ShutdownInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("ShutdownInput [");
            boolean first = true;
            if (this._contextInstance != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_contextInstance=");
                builder.append(this._contextInstance);
            }
            if (this._inputSecret != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_inputSecret=");
                builder.append(this._inputSecret);
            }
            if (this._maxWaitTime != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_maxWaitTime=");
                builder.append(this._maxWaitTime);
            }
            if (this._reason != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_reason=");
                builder.append(this._reason);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

