/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.implementation.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.opendaylight.controller.sal.utils.GlobalConstants;
import org.slf4j.Logger;

public final class ProtocolService<T> {
    private static final int DEFAULT_PRIORITY = 0;
    private final T service;
    private final int priority;

    public static <S> void set(ConcurrentMap<String, ProtocolService<S>> map, Map<?, ?> props, S s, Logger logger) {
        Object value;
        if (map == null) {
            logger.error("Protocol plugin service store is null.");
            return;
        }
        if (s == null) {
            logger.error("Protocol plugin service is null.");
            return;
        }
        if (props == null) {
            logger.error("Service property is null.");
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Received set service request: {}", s);
            for (Map.Entry<?, ?> entry : props.entrySet()) {
                logger.trace("Prop key:({}) value:({})", entry.getKey(), entry.getValue());
            }
        }
        if (!((value = props.get(GlobalConstants.PROTOCOLPLUGINTYPE.toString())) instanceof String)) {
            logger.error("Unexpected protocol type: {}", value);
            return;
        }
        String type = (String)value;
        ProtocolService<S> service = new ProtocolService<S>(props, s);
        ProtocolService<S> old = map.putIfAbsent(type, service);
        while (old != null) {
            if (old.getPriority() >= service.getPriority()) {
                logger.trace("Protocol plugin service for {} is already set: current={}, requested={}", new Object[]{type, old, service});
                return;
            }
            if (map.replace(type, old, service)) break;
            old = map.putIfAbsent(type, service);
        }
        logger.debug("Stored protocol plugin service for {}: {}", (Object)type, service);
    }

    public static <S> void unset(ConcurrentMap<String, ProtocolService<S>> map, Map<?, ?> props, S s, Logger logger) {
        Object value;
        if (map == null) {
            logger.error("Protocol plugin service store is null.");
            return;
        }
        if (s == null) {
            logger.error("Protocol plugin service is null.");
            return;
        }
        if (props == null) {
            logger.error("Service property is null.");
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Received unset service request: {}", s);
            for (Map.Entry<?, ?> entry : props.entrySet()) {
                logger.trace("Prop key:({}) value:({})", entry.getKey(), entry.getValue());
            }
        }
        if (!((value = props.get(GlobalConstants.PROTOCOLPLUGINTYPE.toString())) instanceof String)) {
            logger.error("Unexpected protocol type {}: service={}", value, s);
            return;
        }
        String type = (String)value;
        ProtocolService<S> plugin = new ProtocolService<S>(props, s);
        if (map.remove(type, plugin)) {
            logger.debug("Removed protocol plugin service for {}: {}", (Object)type, plugin);
        } else {
            logger.trace("Ignore unset service request for {}: {}", (Object)type, plugin);
        }
    }

    public ProtocolService(Map<?, ?> props, T s) {
        this.service = s;
        String key = GlobalConstants.PROTOCOLPLUGINPRIORITY.toString();
        Object value = props.get(key);
        this.priority = value instanceof Integer ? (Integer)value : 0;
    }

    public T getService() {
        return this.service;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ProtocolService plugin = (ProtocolService)o;
        return this.service.equals(plugin.service) && this.priority == plugin.priority;
    }

    public int hashCode() {
        return this.service.hashCode() + this.priority * 31;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[service=");
        return builder.append(this.service).append(", priority=").append(this.priority).append(']').toString();
    }
}

